﻿namespace Hims.Infrastructure.Services.Middleware
{
    using Domain.Services;

    using Microsoft.Extensions.DependencyInjection;

    /// <summary>
    /// The IOC container middle ware.
    /// </summary>
    public static class IocContainerMiddleware
    {
        /// <summary>
        /// The register services.
        /// </summary>
        /// <param name="services">
        /// The services.
        /// </param>
        /// <returns>
        /// The <see cref="IServiceCollection"/>.
        /// </returns>
        public static IServiceCollection RegisterBusinessServices(this IServiceCollection services)
        {
            services.AddTransient<ICounsellingService, CounsellingServices>();
            services.AddTransient<INurseNoteService, NurseNoteService>();
            services.AddTransient<IAppointmentCheckService, AppointmentCheckService>();
            services.AddTransient<IQueueService, QueueServices>();
            services.AddTransient<IProgressReportNoteService, ProgressReportNoteService>();
            services.AddTransient<IProgressReportLabService, ProgressReportLabService>();
            services.AddTransient<IProgressReportService, ProgressReportService>();
            services.AddTransient<IPackageService, PackageService>();
            services.AddTransient<IChargeManagementService, ChargeManagementService>();
            services.AddTransient<IBedManagementService, BedManagementService>();
            services.AddTransient<IBedBoardListViewService, BedBoardListViewService>();
            services.AddTransient<IMenuService, MenuService>();
            services.AddTransient<IDischargeService, DischargeService>();
            services.AddTransient<ICompanyService, CompanyServices>();
            services.AddTransient<IFinalBillService, FinalBillService>();
            services.AddTransient<IReceiptService, ReceiptService>();
            services.AddTransient<IServiceOrderService, ServiceOrderService>();
            services.AddTransient<ITimelineService, TimelineService>();
            services.AddTransient<IAdmissionService, AdmissionServices>();
            services.AddTransient<IWebTelemedicineService, WebTelemedicineServices>();
            services.AddTransient<IPatientDeviceDetailsService, PatientDeviceDetailsServices>();
            services.AddTransient<IDoctorDeviceDetailsService, DoctorDeviceDetailsServices>();
            services.AddTransient<IVideoCallHistoryService, VideoCallHistoryServices>();
            services.AddTransient<IUserService, UserServices>();
            services.AddTransient<IAuditLogService, AuditLogServices>();
            services.AddTransient<IResourceService, ResourceServices>();
            services.AddTransient<IReportService, ReportServices>();
            services.AddTransient<IServiceService, ServiceServices>();
            services.AddTransient<ISpecializationService, SpecializationServices>();
            services.AddTransient<ICountryService, CountryServices>();
            services.AddTransient<ICouponService, CouponServices>();
            services.AddTransient<IRoleService, RoleServices>();
            services.AddTransient<IDischargeInstructionService, DischargeInstructionService>();
            services.AddTransient<IWardService, WardService>();
            services.AddTransient<IRoomService, RoomService>();
            services.AddTransient<IDepartmentService, DepartmentService>();
            services.AddTransient<IChargeGroupService, ChargeGroupService>();
            services.AddTransient<IChargeService, ChargeService>();
            services.AddTransient<IBedService, BedService>();
            services.AddTransient<IInsuranceCompanyService, InsuranceCompanyServices>();
            services.AddTransient<IAccountService, AccountServices>();
            services.AddTransient<IAccountSessionService, AccountSessionServices>();
            services.AddTransient<IAccountCredentialService, AccountCredentialServices>();
            services.AddTransient<IAppointmentTransactionService, AppointmentTransactionServices>();
            services.AddTransient<IProviderService, ProviderServices>();
            services.AddTransient<IProviderEncounterService, ProviderEncounterServices>();
            services.AddTransient<ILabOrderValueService, LabOrderValueService>();
            services.AddTransient<IProviderLocationService, ProviderLocationServices>();
            services.AddTransient<IProviderLeaveService, ProviderLeaveServices>();
            services.AddTransient<IProviderDocumentService, ProviderDocumentServices>();
            services.AddTransient<IPatientService, PatientServices>();
            services.AddTransient<IPatientDocumentService, PatientDocumentServices>();
            services.AddTransient<IPatientInsuranceService, PatientInsuranceServices>();
            services.AddTransient<IPatientEmergencyService, PatientEmergencyServices>();
            services.AddTransient<IAppointmentService, AppointmentServices>();
            services.AddTransient<IAppointmentLogService, AppointmentLogServices>();
            services.AddTransient<IAppointmentExceptionLogService, AppointmentExceptionLogServices>();
            services.AddTransient<IEncounterService, EncounterService>();
            services.AddTransient<IPracticeService, PracticeServices>();
            services.AddTransient<IUserService, UserServices>();
            services.AddTransient<IInternalMedicineService, InternalMedicineServices>();
            services.AddTransient<IBehavioralHealthService, BehavioralHealthService>();
            services.AddTransient<ITicketService, TicketServices>();
            services.AddTransient<IChatService, ChatService>();
            services.AddTransient<IGeneralAdviceService, GeneralAdviceServices>();
            services.AddTransient<IExportService, ExportServices>();
            services.AddTransient<IPayUService, PayUService>();
            services.AddTransient<IProviderBankAccountService, ProviderBankAccountServices>();
            services.AddTransient<IValidatorService, ValidatorServices>();
            services.AddTransient<IIcdService, IcdCodeServices>();
            services.AddTransient<IHomeopathyService, HomeopathyServices>();
            services.AddTransient<IDentalEncounterService, DentalEncounterServices>();
            services.AddTransient<IProblemListService, ProblemListServices>();
            services.AddTransient<ILabOrderService, LabOrderService>();
            services.AddTransient<IRadiologyService, RadiologyService>();
            services.AddTransient<IRadiologyValueService, RadiologyValueService>();
            services.AddTransient<ILanguageService, LanguageServices>();
            services.AddTransient<IIconService, IconService>();
            services.AddTransient<IMessageService, MessageService>();
            services.AddTransient<IWalletService, WalletServices>();
            services.AddTransient<IExceptionLogService, ExceptionLogServices>();
            services.AddTransient<IFeedbackService, FeedbackServices>();

            services.AddTransient<IInventoryService, InventoryServices>();
            services.AddTransient<ISupplierService, SupplierServices>();
            services.AddTransient<ICompanyService, CompanyServices>();
            services.AddTransient<IIndentService, IndentServices>();
            services.AddTransient<IIssueService, IssueServices>();
            services.AddTransient<IPharmacyService, PharmacyServices>();
            services.AddTransient<IPharmacyRequestService, PharmacyRequestServices>();
            services.AddTransient<ILaboratoryService, LaboratoryServices>();
            services.AddTransient<ILaboratoryPackageService, LaboratoryPackageServices>();
            services.AddTransient<ISmsLogService, SmsLogservice>();
            services.AddTransient<IPharmacyLogService, PharmacyLogServices>();
            services.AddTransient<ILaboratoryDashboardService, LaboratoryDashboardService>();
            services.AddTransient<IInventoryLogService, InventoryLogServices>();
            services.AddTransient<ILabLogService, LabLogServices>();
            services.AddTransient<IScanLogService, ScanLogServices>();
            services.AddTransient<IExcelUploadHistoryService, ExcelUploadHistoryServices>();
            services.AddTransient<IDashboardWidgetService, DashboardWidgetServices>();
            services.AddTransient<IDynamicReportService, DynamicReportServices>();
            services.AddTransient<IDynamicDashboardService, DynamicDashboardService>();
            services.AddTransient<IVisitTypeService, VisitTypeService>();
            services.AddTransient<IChargeTypesService, ChargeTypesService>();
            services.AddTransient<IFloorService, FloorService>();
            services.AddTransient<IInsuranceAdmissionService, InsuranceAdmissionServices>();
            services.AddTransient<INurseModuleService, NurseModuleServices>();
            services.AddTransient<INurseShiftService, NurseShiftService>();
            services.AddTransient<IVitalTypeService, VitalTypeService>();
            services.AddTransient<IProgressReportVitalsService, ProgressReportVitalsService>();
            services.AddTransient<IProgressReportAssessmentsService, ProgressReportAssessmentsService>();
            services.AddTransient<IUnitTypeService, UnitTypeService>();
            services.AddTransient<IDiscountManagementService, DiscountManagementServices>();
            services.AddTransient<IAssessmentTypeService, AssessmentTypeService>();
            services.AddTransient<IPharmacyTrackingService, PharmacyTrackingServices>();
            services.AddTransient<IOperationService, OperationServices>();
            services.AddTransient<IDemandBookService, DemandBookService>();
            services.AddTransient<IModulesMasterService, ModulesMasterService>();
            services.AddTransient<IPharmacyWareHouseService, PharmacyWareHouseServices>();
            services.AddTransient<IMealTypesService, MealTypesService>();
            services.AddTransient<IProgressReportDietService, ProgressReportDietService>();
            services.AddTransient<IGynEncounterService, GynEncounterServices>();
            services.AddTransient<IEmployeeShiftService, EmployeeShiftServices>();
            services.AddTransient<ILeaveTypeService, LeaveTypeServices>();
            services.AddTransient<IOBEncounterService, OBEncounterServices>();
            services.AddTransient<IProviderScheduleService, ProviderScheduleService>();
            services.AddTransient<IHwcPatientService, HwcPatientServices>();
            services.AddTransient<IScanTestService, ScanTestService>();
            services.AddTransient<IChargeCategoryService, ChargeCategoryService>();
            services.AddTransient<IScanMachineService, ScanMachineService>();
            services.AddTransient<ILabDepartmentService, LabDepartmentServices>();
            services.AddTransient<IReferenceTypesServices, ReferenceTypesServices>();
            services.AddTransient<IPayTypeService, PayTypeServices>();
            services.AddTransient<IScanMachineAvailabilityService, ScanMachineAvailabilityService>();
            services.AddTransient<IPharmacyDepartmentService, PharmacyDepartmentServices>();
            services.AddTransient<IPatientEncounterService, PatientEncounterServices>();
            services.AddTransient<IWebNotificationService, WebNotificationServices>();
            services.AddTransient<IBookScanAppointmentService, BookScanAppointmentService>();
            services.AddTransient<ISettingService, SettingServices>();
            services.AddTransient<IScanClassificationService, ScanClassificationService>();
            services.AddTransient<IScanSubClassificationService, ScanSubClassificationService>();
            services.AddTransient<IInventoryStoreService, InventoryStoreServices>();
            services.AddTransient<IProviderMedicationService, ProviderMedicationServices>();
            services.AddTransient<IOrderPrescriptionService, OrderPrescriptionService>();
            services.AddTransient<ILabsService, LabsServices>();
            services.AddTransient<IAppointmentTypesService, AppointmentTypesService>();
            services.AddTransient<IMachineService, MachineService>();
            services.AddTransient<IDynamicTemplateService, DynamicTemplateService>();
            services.AddTransient<ILabTransactionService, LabTransactionServices>();
            services.AddTransient<IIdProofService, IdProofService>();
            services.AddTransient<IPayCategoryService, PayCategoryServices>();
            services.AddTransient<ISalutationService, SalutationService>();
            services.AddTransient<IComponentTypeService, ComponentTypeService>();
            services.AddTransient<IComponentService, ComponentService>();
            services.AddTransient<ITemplateService, TemplateService>();
            services.AddTransient<IReferralDoctorService, ReferralDoctorService>();
            services.AddTransient<IProviderScheduleChargesService, ProviderSchduleChargesService>();
            services.AddTransient<IConsultationTypeService, ConsultationTypeService>();
            services.AddTransient<IProviderAvailabilityService, ProviderAvailabilityServices>();
            services.AddTransient<IProviderScheduleVisitsService, ProviderSchduleVisitsService>();
            services.AddTransient<ICubicleService, CubicleService>();
            services.AddTransient<IIvfEncounterServices, IvfEncounterServices>();
            services.AddTransient<IWorkingHourService, WorkingHourServices>();
            services.AddTransient<IEncounterTypeService, EncounterTypeService>();
            services.AddTransient<ISessionTypeService, SessionTypeServices>();
            services.AddTransient<ISessionService, SessionService>();
            services.AddTransient<IUserExcelHistoryService, UserExcelHistoryService>();
            services.AddTransient<IPaymentInitiationLogService, PaymentInitiationLogService>();
            services.AddTransient<IPatientChatBoxService, PatientChatBoxService>();
            services.AddTransient<IChargeModuleService, ChargeModuleServices>();
            services.AddTransient<IPaymentMapHelperService, PaymentMapHelperService>();
            services.AddTransient<IOTRoomAvailabilityService, OTRoomAvailabilityService>();
            services.AddTransient<IOTRegisterService, OTRegisterService>();
            services.AddTransient<ICaseTypeService, CaseTypeServices>();
            services.AddTransient<IPackageModuleService, PackageModuleServices>();
            services.AddTransient<IPatientExcelHistoryService, PatientExcelHistoryService>();
            services.AddTransient<IDoctorUnitService, DoctorUnitService>();
            services.AddTransient<IDoctorScheduleVisitsService, DoctorScheduleVisitsService>();
            services.AddTransient<IDynamicTemplateConfigService, DynamicTemplateConfigService>();
            services.AddTransient<IHealthCardService, HealthCardService>();
            services.AddTransient<IAmbulanceService, AmbulanceService>();
            services.AddTransient<IDriverDetailService, DriverDetailService>();
            services.AddTransient<IAmbulanceRecieptService, AmbulanceRecieptService>();
            services.AddTransient<IPediatricEncounterService, PediatricEncounterServices>();
            services.AddTransient<IReasonsService, ReasonsService>();
            services.AddTransient<IAuthorityMasterService, AuthorityMasterService>();
            services.AddTransient<IInitialVendorService, InitialVendorServices>();
            services.AddTransient<IEncounterTemplateService, EncounterTemplateServices>();
            services.AddTransient<IVaccineService, VaccineServices>();
            services.AddTransient<IGatePassService, GatePassService>();
            services.AddTransient<IMasterBillService, MasterBillService>();
            services.AddTransient<IDietEncounterService, DietEncounterService>();

            services.AddTransient<IDietGuidLinesService, DietGuidLinesService>();
            services.AddTransient<IRelationsService, RelationsService>();
            services.AddTransient<IDoctorAppointmentNoticeService, DoctorAppointmentNoticeService>();

            services.AddTransient<IPediatricChartService, PediatricChartServices>();
            services.AddTransient<IGeneralNotificationService, GeneralNotificationServices>();
            services.AddTransient<IScanAppointmentNoticeService, ScanAppointmentNoticeService>();

            services.AddTransient<ILabVacutainerService, LabVacutainerService>();
            services.AddTransient<IEmergencyEncounterService, EmergencyEncounterServices>();
            services.AddTransient<IDietSlotsMasterService, DietSlotsMastersServices>();
            services.AddTransient<IDietItemsService, DietItemsServices>();
            services.AddTransient<IDietConditionHeaderService, DietConditionHeaderServices>();

            services.AddTransient<IDenverChartService, DenverChartService>();
            services.AddTransient<IBirthCertificateService, BirthCertificateService>();
            services.AddTransient<IInPatientsViewService, InPatientsViewServices>();
            services.AddTransient<IQuotationService, QuotationServices>();
            services.AddTransient<ITpaService, TpaService>();

            services.AddTransient<IContactDetailsService, ContactDetailsServices>();
            services.AddTransient<IFeedbackDetailsService, FeedbackDetailsServices>();
            services.AddTransient<ICallHistoryDataService, CallHistoryServices>();
            services.AddTransient<IWhatsAppTicketsService, WhatsAppTicketsService>();
            services.AddTransient<IRegisterService, RegisterService>();
            services.AddTransient<IPhysiotherapyEncounterService, PhysiotherapyEncounterService>();
            services.AddTransient<IInsuranceTemplateService, InsuranceTemplateService>();
            services.AddTransient<IGeneticSpecialityEncounterService, GeneticSpecialityEncounterService>();
            services.AddTransient<IEncountersLogService, EncountersLogServices>();
            return services;
        }
    }
}