﻿namespace Hims.Domain.Entities.Labs
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The lab main detail.
    /// </summary>
    public class LabMainDetail
    {
        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        [Key,Identity]
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the test code.
        /// </summary>
        /// <value>
        /// The test code.
        /// </value>
        public string TestCode { get; set; }

        /// <summary>
        /// Gets or sets the lab department identifier.
        /// </summary>
        /// <value>
        /// The lab department identifier.
        /// </value>
        public int LabDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the lab sample type identifier.
        /// </summary>
        /// <value>
        /// The lab sample type identifier.
        /// </value>
        public int? LabSampleTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabMainDetail"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is internal lab.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is internal lab; otherwise, <c>false</c>.
        /// </value>
        public bool IsInternalLab { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is external lab.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is external lab; otherwise, <c>false</c>.
        /// </value>
        public bool IsExternalLab { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }


        /// <summary>
        /// Gets or sets the module master identifier.
        /// </summary>
        /// <value>
        /// The module master identifier.
        /// </value>
        [IgnoreUpdate]
        public int ModulesMasterId { get; set; }

        /// <summary>
        /// Gets or sets the sample usage.
        /// </summary>
        /// <value>
        /// The sample usage.
        /// </value>
        public string SampleUsage { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [nabl required].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [nabl required]; otherwise, <c>false</c>.
        /// </value>
        public bool NablRequired { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [consent form required].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [consent form required]; otherwise, <c>false</c>.
        /// </value>
        public bool ConsentFormRequired { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [assign doctor required].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [assign doctor required]; otherwise, <c>false</c>.
        /// </value>
        public bool AssignDoctorRequired { get; set; }

        /// <summary>
        /// Gets or sets the lab vacutainer identifier.
        /// </summary>
        /// <value>
        /// The lab vacutainer identifier.
        /// </value>
        public int LabVacutainerId { get; set; }

        /// <summary>
        /// Gets or sets the no of samples collect.
        /// </summary>
        /// <value>
        /// The no of samples collect.
        /// </value>
        public int NoOfSamplesCollect { get; set; }

        /// <summary>
        /// Gets or sets the no of samples collect text.
        /// </summary>
        /// <value>
        /// The no of samples collect text.
        /// </value>
        public string NoOfSamplesCollectText { get; set; }

        /// <summary>
        /// Gets or sets the test precaution.
        /// </summary>
        /// <value>
        /// The test precaution.
        /// </value>
        public string TestPrecaution { get; set; }
    }
}
