﻿namespace Hims.Domain.Entities.Labs
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab transfer header.
    /// </summary>
    public class LabTransferHeader
    {
        /// <summary>
        /// Gets or sets the lab transfer header identifier.
        /// </summary>
        /// <value>
        /// The lab transfer header identifier.
        /// </value>
        [Key,Identity]
        public int LabTransferHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the transfer number.
        /// </summary>
        /// <value>
        /// The transfer number.
        /// </value>
        public string TransferNumber { get; set; }

        /// <summary>
        /// Gets or sets the transfered by.
        /// </summary>
        /// <value>
        /// The transfered by.
        /// </value>
        public int TransferedBy { get; set; }

        /// <summary>
        /// Gets or sets the transfered date.
        /// </summary>
        /// <value>
        /// The transfered date.
        /// </value>
        public DateTime TransferedDate { get; set; }

        /// <summary>
        /// Gets or sets the transfered location identifier.
        /// </summary>
        /// <value>
        /// The transfered location identifier.
        /// </value>
        public int TransferedLocationId { get; set; }

        /// <summary>
        /// Gets or sets the received by.
        /// </summary>
        /// <value>
        /// The received by.
        /// </value>
        public int? ReceivedBy { get; set; }

        /// <summary>
        /// Gets or sets the received date.
        /// </summary>
        /// <value>
        /// The received date.
        /// </value>
        public DateTime? ReceivedDate { get; set; }

        /// <summary>
        /// Gets or sets the transferred temperature.
        /// </summary>
        /// <value>
        /// The transferred temperature.
        /// </value>
        public int? TransferredTemperature { get; set; }

        /// <summary>
        /// Gets or sets the received temperature.
        /// </summary>
        /// <value>
        /// The received temperature.
        /// </value>
        public int? ReceivedTemperature { get; set; }

        /// <summary>
        /// Gets or sets the transferred temperature comments.
        /// </summary>
        /// <value>
        /// The transferred temperature comments.
        /// </value>
        public string TransferredTemperatureComments { get; set; }

        /// <summary>
        /// Gets or sets the received temperature comments.
        /// </summary>
        /// <value>
        /// The received temperature comments.
        /// </value>
        public string ReceivedTemperatureComments { get; set; }
    }
}
