﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The Insurance Company Service interface.
    /// </summary>
    public interface IInsuranceCompanyService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<InsuranceCompanyModel>> FetchAsync(InsuranceCompanyFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(InsuranceCompanyModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(InsuranceCompanyModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="insuranceCompanyId">
        /// The insuranceCompany id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int insuranceCompanyId);

        /// <summary>
        /// The modify status async.
        /// </summary>
        /// <param name="insuranceCompanyId">
        /// The insuranceCompany id.
        /// </param>
        /// <param name="modifiedBy">
        /// The modified By.
        /// </param>
        /// <param name="status">
        /// The status.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(int insuranceCompanyId, int modifiedBy, bool status);


        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="insurenceCompanyId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindNameByInsuranceId(int insurenceCompanyId);
    }
}
