﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The ticket assignee model.
    /// </summary>
    public class TicketAssigneeModel
    {
        /// <summary>
        /// Gets or sets the ticket assignee id.
        /// </summary>
        public long TicketAssigneeId { get; set; }

        /// <summary>
        /// Gets or sets the ticket id.
        /// </summary>
        public long TicketId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the assigned to.
        /// </summary>
        public int AssignedTo { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the assigned date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the owner name.
        /// </summary>
        public string? OwnerName { get; set; }

        /// <summary>
        /// Gets or sets the assignee account id.
        /// </summary>
        public int? AssigneeAccountId { get; set; }
    }
}
