﻿#nullable enable
namespace Hims.Shared.UserModels.OBEncounter
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Hims.Shared.Library.Enums;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class InsertModel
    {
        /// <summary>
        /// Gets or sets the gyn encounter id.
        /// </summary>
        public int OBEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encounter date.
        /// </summary>
        public DateTime OBEncounterDate { get; set; }

        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }

        /// <summary>
        /// Gets or sets the problem list.
        /// </summary>
        public string? ProblemList { get; set; }

        /// <summary>
        /// Gets or sets the brief ros.
        /// </summary>
        public string? BriefRos { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the isadmission.
        /// </summary>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the json string.
        /// </summary>
        public string JsonString { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public OBEncounterType Type { get; set; }

        /// <summary>
        /// Gets or sets the anc card closure.
        /// </summary>
        public string ANCCaredClosure { get; set; }

        /// <summary>
        /// Gets or sets the breast examination.
        /// </summary>
        public string BreastExamination { get; set; }

        /// <summary>
        /// Gets or sets the anc card generation.
        /// </summary>
        public string ANCCardGeneration { get; set; }

        /// <summary>
        /// Gets or sets the complaints.
        /// </summary>
        public string Complaints { get; set; }

        /// <summary>
        /// Gets or sets the complaints.
        /// </summary>
        public string ObstetricExamination { get; set; }

        /// <summary>
        /// Gets or sets the vaginal examination.
        /// </summary>
        public string VaginalExamination { get; set; }
        /// <summary>
        /// Gets or sets the order prescription.
        /// </summary>
        public string OrderPrescription { get; set; }
        /// <summary>
        /// Gets or sets the drug history.
        /// </summary>
        public string DrugHistory { get; set; }
        /// <summary>
        /// Gets or sets the menstrual history.
        /// </summary>
        public string MenstrualHistory { get; set; }
        /// <summary>
        /// Gets or sets the other detail.
        /// </summary>
        public string OtherDetail { get; set; }

        /// <summary>
        /// Gets or sets the VTE Risk.
        /// </summary>
        public string VTERisk { get; set; }
        /// <summary>
        /// Gets or sets the vaccine.
        /// </summary>
        public string Vaccine { get; set; }
        /// <summary>
        /// Gets or sets the postnantal visit
        /// </summary>
        public string PostnantalVisit { get; set; }
        /// <summary>
        /// Gets or sets the meaure
        /// </summary>
        public string Measure { get; set; }
        /// <summary>
        /// Gets or sets the general examination
        /// </summary>
        public string GeneralExamination { get; set; }
        /// <summary>
        /// Gets or sets the breech
        /// </summary>
        public string Breech { get; set; }

        public string? RefferalOrder { get; set; }

        /// <summary>
        /// Get or sets syndromes
        /// </summary>
        public string Syndromes { get; set; }
        /// <summary>
        /// Get or sets syndromes
        /// </summary>
        public string OPManagement { get; set; }
        public int? CommonEncounterId { get; set; }
    }
}