﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacy product.
    /// </summary>
    public class PharmacyProduct
    {
        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        [Key, Identity]
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the medication identifier.
        /// </summary>
        /// <value>
        /// The medication identifier.
        /// </value>
        public string MedicationId { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit qty.
        /// </summary>
        public int PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the sale unit qty.
        /// </summary>
        public int SaleUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the company id.
        /// </summary>
        public int CompanyId { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int? SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit.
        /// </summary>
        public int PurchaseUnit { get; set; }

        /// <summary>
        /// Gets or sets the sale unit.
        /// </summary>
        public int SaleUnit { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is product expire.
        /// </summary>
        public bool IsProductExpire { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the HSN code.
        /// </summary>
        /// <value>
        /// The HSN code.
        /// </value>
        public string HSNCode { get; set; }

        /// <summary>
        /// Gets or sets the suppliers.
        /// </summary>
        /// <value>
        /// The suppliers.
        /// </value>
        public string Suppliers { get; set; }

        /// <summary>
        /// Gets or sets the scheduled drug.
        /// </summary>
        /// <value>
        /// The scheduled drug.
        /// </value>
        public string ScheduledDrug { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is general item.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is general item; otherwise, <c>false</c>.
        /// </value>
        public bool IsGeneralItem { get; set; }

        /// <summary>
        /// Gets or sets the storage type identifier.
        /// </summary>
        /// <value>
        /// The storage type identifier.
        /// </value>
        public int? StorageTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product sub type identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product sub type identifier.
        /// </value>
        public int? PharmacyProductSubTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product type identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product type identifier.
        /// </value>
        public int? PharmacyProductTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [only consumable].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [only consumable]; otherwise, <c>false</c>.
        /// </value>
        public bool OnlyConsumable { get; set; }

        /// <summary>
        /// Gets or sets the potency.
        /// </summary>
        /// <value>
        /// The potency.
        /// </value>
        public string Potency { get; set; }

        /// <summary>
        /// Gets or sets the dosage.
        /// </summary>
        /// <value>
        /// The dosage.
        /// </value>
        public string Dosage { get; set; }

        /// <summary>
        /// Gets or sets the formula.
        /// </summary>
        /// <value>
        /// The formula.
        /// </value>
        public string Formula { get; set; }

        /// <summary>
        /// Gets or sets the strength.
        /// </summary>
        /// <value>
        /// The strength.
        /// </value>
        public string Strength { get; set; }

        /// <summary>
        /// Gets or sets the drug risk identifier.
        /// </summary>
        /// <value>
        /// The drug risk identifier.
        /// </value>
        public int? DrugRiskId { get; set; }

        /// <summary>
        /// Gets or sets the nabh category identifier.
        /// </summary>
        /// <value>
        /// The nabh category identifier.
        /// </value>
        public int? NABHCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the dosage type identifier.
        /// </summary>
        /// <value>
        /// The dosage type identifier.
        /// </value>
        public int? DosageTypeId { get; set; }

        /// <summary>
        /// Gets or sets the med frequency master identifier.
        /// </summary>
        /// <value>
        /// The med frequency master identifier.
        /// </value>
        public int? MedFrequencyMasterId { get; set; }

        /// <summary>
        /// Gets or sets the no of times.
        /// </summary>
        /// <value>
        /// The no of times.
        /// </value>
        public int? NoOfTimes { get; set; }

        /// <summary>
        /// Gets or sets the inventory expiry.
        /// </summary>
        /// <value>
        /// The inventory expiry.
        /// </value>
        public int? InventoryExpiry { get; set; }

        /// <summary>
        /// Gets or sets the formulation identifier.
        /// </summary>
        /// <value>
        /// The formulation identifier.
        /// </value>
        public int? FormulationId { get; set; }

        /// <summary>
        /// Gets or sets the med route identifier.
        /// </summary>
        /// <value>
        /// The med route identifier.
        /// </value>
        public int? MedRouteId { get; set; }

        /// <summary>
        /// Gets a value indicating whether [sale loose].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [sale loose]; otherwise, <c>false</c>.
        /// </value>
        public bool SaleLoose { get; set; }

        /// <summary>
        /// Gets or sets the fixed dose.
        /// </summary>
        /// <value>
        /// The fixed dose.
        /// </value>
        public double? FixedDose { get; set; }

        /// <summary>
        /// Gets or sets the alchohol interaction.
        /// </summary>
        /// <value>
        /// The alchohol interaction.
        /// </value>
        public string AlchoholInteraction { get; set; }

        /// <summary>
        /// Gets or sets the pregnancy interaction.
        /// </summary>
        /// <value>
        /// The pregnancy interaction.
        /// </value>
        public string PregnancyInteraction { get; set; }

        /// <summary>
        /// Gets or sets the expert advice.
        /// </summary>
        /// <value>
        /// The expert advice.
        /// </value>
        public string ExpertAdvice { get; set; }

        /// <summary>
        /// Gets or sets the common side effects.
        /// </summary>
        /// <value>
        /// The common side effects.
        /// </value>
        public string CommonSideEffects { get; set; }

        /// <summary>
        /// Gets or sets the medicine FAQ.
        /// </summary>
        /// <value>
        /// The medicine FAQ.
        /// </value>
        public string MedicineFaq { get; set; }

        /// <summary>
        /// Gets or sets the medicine interaction.
        /// </summary>
        /// <value>
        /// The medicine interaction.
        /// </value>
        public string MedicineInteraction { get; set; }

        /// <summary>
        /// Gets or sets the usage.
        /// </summary>
        /// <value>
        /// The usage.
        /// </value>
        public string Usage { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [inventory item].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [inventory item]; otherwise, <c>false</c>.
        /// </value>
        public bool InventoryItem { get; set; }

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int? ModulesMasterId { get; set; }
    }
}
