﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.Library;
    using Shared.Library.Enums;
    using Shared.UserModels;
    using Hims.Shared.Library.Helpers;

    /// <summary>
    /// The InternalMedicineService interface.
    /// </summary>
    public interface IInternalMedicineService
    {
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<InternalMedicineModel> FindAsync(int appointmentId, bool isAdmission);

        /// <summary>
        /// Finds the dashboard asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="type">The type.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<EncounterResource> FindDashboardAsync(int appointmentId, InternalMedicine type, bool isAdmission);

        /// <summary>
        /// The add internal medicine async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(EncounterModifyModel model);

        /// <summary>
        /// The add alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> AddAltAsync(EncounterModifyModel model);

        /// <summary>
        /// The update internal medicine async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(EncounterModifyModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAltAsync(EncounterModifyModel model);

        /// <summary>
        /// The find prescription async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<InternalMedicinePrescriptionModel> FindPrescriptionAsync(int appointmentId);

        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<InternalMedicineFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);

        /// <summary>
        /// Gets the account based on appointment identifier.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<AppointmentModel> GetAccountBasedOnAppointmentId(long appointmentId, bool isAdmission);
    }
}
