﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Common;
    using Hims.Shared.UserModels.NurseShift.BedView;
    using Hims.Shared.UserModels.NurseShift.Module;
    using Hims.Shared.UserModels.NurseShift.Shift;
    using Shared.EntityModels;

    /// <summary>
    /// The Nurse Module Service interface.
    /// </summary>
    public interface INurseModuleService
    {
        Task<IEnumerable<AvailableNurseModel>> GetAvailableNurseAsync(AvailableNursePayloadModel model);
        Task<IEnumerable<ShiftsBasicsModel>> FetchShiftsBasicsAsync();

        Task<IEnumerable<BedViewFetchModel>> FetchBedWiseAsync(BedViewFilterModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<NurseModel>> FetchAsync(NurseFilterModel model);

        /// <summary>
        /// The fetch slots async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ShiftSlotModel>> FetchSlotsAsync();

        /// <summary>
        /// The insert slots async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> InsertSlotsAsync(ShiftSlotModel model);

        /// <summary>
        /// The insert shift async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<GenericResponse> InsertShiftAsync(ShiftModel model);

        /// <summary>
        /// The insert shift async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<GenericResponse> UpdateShiftAsync(ShiftModel model);

        /// <summary>
        /// The fetch shifts async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ShiftsModel>> FetchShiftAsync(ShiftsFilterModel model);

        /// <summary>
        /// The insert slots async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(ShiftModel model);
    }
}
