﻿namespace Hims.Admin.Extensions
{
    using Microsoft.AspNetCore.Builder;
    using Middleware;

    /// <summary>
    /// The anti forgery token extension.
    /// </summary>
    public static class AntiForgeryTokenExtension
    {
        /// <summary>
        /// The use anti forgery token.
        /// </summary>
        /// <param name="builder">
        /// The builder.
        /// </param>
        /// <returns>
        /// The <see cref="IApplicationBuilder"/>.
        /// </returns>
        public static IApplicationBuilder UseAntiForgeryToken(this IApplicationBuilder builder) => builder.UseMiddleware<AntiForgeryTokenMiddleware>();
    }
}
