﻿namespace Hims.Shared.UserModels.WebNotification
{
    using System;

    /// <summary>
    /// The web notification display model.
    /// </summary>
    public class WebNotificationDisplayModel
    {
        /// <summary>
        /// Gets or sets the web notification identifier.
        /// </summary>
        /// <value>
        /// The web notification identifier.
        /// </value>
        public int WebNotificationId { get; set; }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        /// <value>
        /// The patient mobile.
        /// </value>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the web notification priority identifier.
        /// </summary>
        /// <value>
        /// The web notification priority identifier.
        /// </value>
        public int WebNotificationPriorityId { get; set; }

        /// <summary>
        /// Gets or sets the web notification log type identifier.
        /// </summary>
        /// <value>
        /// The web notification log type identifier.
        /// </value>
        public int WebNotificationLogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the redirection link.
        /// </summary>
        /// <value>
        /// The redirection link.
        /// </value>
        public string RedirectionLink { get; set; }

        /// <summary>
        /// Gets or sets the allowed roles.
        /// </summary>
        /// <value>
        /// The allowed roles.
        /// </value>
        public string AllowedRoles { get; set; }

        /// <summary>
        /// Gets or sets the allowed accounts.
        /// </summary>
        /// <value>
        /// The allowed accounts.
        /// </value>
        public string AllowedAccounts { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is read.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is read; otherwise, <c>false</c>.
        /// </value>
        public bool IsRead { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [payment status].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [payment status]; otherwise, <c>false</c>.
        /// </value>
        public bool? PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the reference identifier.
        /// </summary>
        /// <value>
        /// The reference identifier.
        /// </value>
        public long? ReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted reference identifier.
        /// </summary>
        /// <value>
        /// The encrypted reference identifier.
        /// </value>
        public string EncryptedReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public string Priority { get; set; }

        /// <summary>
        /// Gets or sets the type of the log.
        /// </summary>
        /// <value>
        /// The type of the log.
        /// </value>
        public string LogType { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        /// <value>
        /// The patient age.
        /// </value>
        public int PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        /// <value>
        /// The patient gender.
        /// </value>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail URL.
        /// </summary>
        /// <value>
        /// The patient thumbnail URL.
        /// </value>
        public string PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the web notification type identifier.
        /// </summary>
        /// <value>
        /// The web notification type identifier.
        /// </value>
        public int WebNotificationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the type of the module.
        /// </summary>
        /// <value>
        /// The type of the module.
        /// </value>
        public string ModuleType { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [active status].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [Active status]; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }
    }
}
