﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class Encounter
    {
        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        [Key, Identity]
        public int EncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        [IgnoreUpdate]
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encounter date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime EncounterDate { get; set; }

        /// <summary>
        /// Gets or sets the cheif complaints.
        /// </summary>
        public string? CheifComplaints { get; set; }

        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }

        /// <summary>
        /// Gets or sets the problem list.
        /// </summary>
        public string? ProblemList { get; set; }

        /// <summary>
        /// Gets or sets the ros.
        /// </summary>
        public string? Ros { get; set; }

        /// <summary>
        /// Gets or sets the heent.
        /// </summary>
        public string? Heent { get; set; }

        /// <summary>
        /// Gets or sets the skin.
        /// </summary>
        public string? Skin { get; set; }

        /// <summary>
        /// Gets or sets the respiratory.
        /// </summary>
        public string? Respiratory { get; set; }

        /// <summary>
        /// Gets or sets the cardiovascular.
        /// </summary>
        public string? Cardiovascular { get; set; }

        /// <summary>
        /// Gets or sets the abdomen.
        /// </summary>
        public string? Abdomen { get; set; }

        /// <summary>
        /// Gets or sets the extremities.
        /// </summary>
        public string? Extremities { get; set; }

        /// <summary>
        /// Gets or sets the ekg.
        /// </summary>
        public string? EKG { get; set; }

        /// <summary>
        /// Gets or sets the musculoskeletal.
        /// </summary>
        public string? Musculoskeletal { get; set; }

        /// <summary>
        /// Gets or sets the neurology.
        /// </summary>
        public string? Neurology { get; set; }

        /// <summary>
        /// Gets or sets the diagnosis.
        /// </summary>
        public string? Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the soap notes.
        /// </summary>
        public string? SoapNotes { get; set; }

        /// <summary>
        /// Gets or sets the discharge advice.
        /// </summary>
        public string? DischargeAdvice { get; set; }

        /// <summary>
        /// Gets or sets the allergies.
        /// </summary>
        public string? Allergies { get; set; }

        /// <summary>
        /// Gets or sets the social history.
        /// </summary>
        public string? SocialHistory { get; set; }

        /// <summary>
        /// Gets or sets the radiology.
        /// </summary>
        public string? Radiology { get; set; }

        /// <summary>
        /// Gets or sets the hospitalization surgery.
        /// </summary>
        public string? HospitalizationSurgery { get; set; }

        /// <summary>
        /// Gets or sets the family medical history.
        /// </summary>
        public string? FamilyMedicalHistory { get; set; }

        /// <summary>
        /// Gets or sets the preventive care.
        /// </summary>
        public string? PreventiveCare { get; set; }

        /// <summary>
        /// Gets or sets the immunization.
        /// </summary>
        public string? Immunization { get; set; }

        /// <summary>
        /// Gets or sets the ic dcodes.
        /// </summary>
        public string? ICDcodes { get; set; }

        /// <summary>
        /// Gets or sets the medications.
        /// </summary>
        public string? Medications { get; set; }

        /// <summary>
        /// Gets or sets the lab orders.
        /// </summary>
        public string? LabOrders { get; set; }

        /// <summary>
        /// Gets or sets the follow up.
        /// </summary>
        public string? FollowUp { get; set; }

        /// <summary>
        /// Gets or sets the cp tcodes.
        /// </summary>
        public string? CPTcodes { get; set; }

        /// <summary>
        /// Gets or sets the stress test.
        /// </summary>
        public string? StressTest { get; set; }

        /// <summary>
        /// Gets or sets the history radiology.
        /// </summary>
        public string? HistoryRadiology { get; set; }

        /// <summary>
        /// Gets or sets the hpo.
        /// </summary>
        public string? HPO { get; set; }

        /// <summary>
        /// Gets or sets the pastand current medications.
        /// </summary>
        public string? PastandCurrentMedications { get; set; }

        /// <summary>
        /// Gets or sets the history laborder.
        /// </summary>
        public string? HistoryLaborder { get; set; }

        /// <summary>
        /// Gets or sets the angiogram.
        /// </summary>
        public string? Angiogram { get; set; }

        /// <summary>
        /// Gets or sets the handouts.
        /// </summary>
        public string? Handouts { get; set; }

        /// <summary>
        /// Gets or sets the records request.
        /// </summary>
        public string? RecordsRequest { get; set; }

        /// <summary>
        /// Gets or sets the consultations.
        /// </summary>
        public string? Consultations { get; set; }

        /// <summary>
        /// Gets or sets the too.
        /// </summary>
        public string? TOO { get; set; }

        /// <summary>
        /// Gets or sets the notes.
        /// </summary>
        public string? Notes { get; set; }

        /// <summary>
        /// Gets or sets the general advice.
        /// </summary>
        public string? GeneralAdvice { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the current medications.
        /// </summary>
        public string? CurrentMedications { get; set; }

        /// <summary>
        /// Gets or sets the medication comment.
        /// </summary>
        public string? MedicationComment { get; set; }
        
    }
}