﻿namespace Hims.Domain.Entities.Labs
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab parameter observed value.
    /// </summary>
    public class LabParameterObservedValue
    {
        /// <summary>
        /// Gets or sets the lab parameter observed value identifier.
        /// </summary>
        /// <value>
        /// The lab parameter observed value identifier.
        /// </value>
        [Key, Identity]
        public long LabParameterObservedValueId { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab component header identifier.
        /// </summary>
        /// <value>
        /// The lab component header identifier.
        /// </value>
        public int? LabComponentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter header identifier.
        /// </summary>
        /// <value>
        /// The lab parameter header identifier.
        /// </value>
        public int LabParameterHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter detail identifier.
        /// </summary>
        /// <value>
        /// The lab parameter detail identifier.
        /// </value>
        public int? LabParameterDetailId { get; set; } // to be removed in future.

        /// <summary>
        /// Gets or sets the observed value.
        /// </summary>
        /// <value>
        /// The observed value.
        /// </value>
        public string ObservedValue { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabParameterObservedValue"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }
    }
}
