﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider location.
    /// </summary>
    public class ProviderLocation
    {
        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        [Key, Identity]
        public int ProviderLocationId { get; set; }

        /// <summary>a
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the consultation duration.
        /// </summary>
        public short? ConsultationDuration { get; set; }

        /// <summary>
        /// Gets or sets the consultation charges.
        /// </summary>
        public decimal? ConsultationCharges { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine duration.
        /// </summary>
        public short? TelemedicineDuration { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public decimal? TelemedicineCharges { get; set; }

        /// <summary>
        /// Gets or sets the in patient duration.
        /// </summary>
        public short? InPatientDuration { get; set; }

        /// <summary>
        /// Gets or sets the out patient duration.
        /// </summary>
        public short? OutPatientDuration { get; set; }

        /// <summary>
        /// Gets or sets the casualty duration.
        /// </summary>
        public short? CasualtyDuration { get; set; }

        /// <summary>
        /// Gets or sets the follow up days.
        /// </summary>
        public short? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string AvailableDays { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Availability.
        /// </summary>
        public string Availability { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the follow up days for ip.
        /// </summary>
        public short? FollowUpDaysForIp { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public string Duration { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the is telemedicine.
        /// </summary>
        public bool IsTelemedicine { get; set; }

        /// <summary>
        /// Gets or sets the is online consultation.
        /// </summary>
        public bool IsOnlineConsultation { get; set; }
    }
}
