﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The excel upload history service interface.
    /// </summary>
    public interface IExcelUploadHistoryService
    {
        /// <summary>
        /// The modify excel upload async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> ModifyExcelUploadAsync(ExcelUploadHistoryModel model);

        /// <summary>
        /// The fetch all async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<ExcelUploadHistoryModel>> FetchAllAsync(ExcelUploadHistoryModel model);

        /// <summary>
        /// The get single excel history.
        /// </summary>
        /// <param name="excelUploadHistoryId">
        /// The excel upload history id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<ExcelUploadHistoryModel> GetSingleExcelHistory(int excelUploadHistoryId);
    }
}
