﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The Appointment new model
    /// </summary>
    public class AppointmentNewModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the email id.
        /// </summary>
        public int? EmailDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the email id.
        /// </summary>
        public int? EmailHeadersId { get; set; }

        /// <summary>
        /// Gets or sets the email id.
        /// </summary>
        public int? ReplyEmailDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int? EncounterId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string? EncryptedPatientId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderLocationId { get; set; }
        
        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string? Reason { get; set; }

        /// <summary>
        /// Gets or sets the provider gender.
        /// </summary>
        public string? ProviderGender { get; set; }

        /// <summary>
        /// Gets or sets the provider age.
        /// </summary>
        public short? ProviderAge { get; set; }

        /// <summary>
        /// Gets or sets the provider thumbnail url.
        /// </summary>
        public string? ProviderThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string? PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the provider location.
        /// </summary>
        public string? ProviderLocation { get; set; }

        /// <summary>
        /// Gets or sets the currency symbol.
        /// </summary>
        public char CurrencySymbol { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient account id.
        /// </summary>
        public int PatientAccountId { get; set; }

        /// <summary>Gets or sets the provider account id.</summary>
        public int ProviderAccountId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public char? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient email.
        /// </summary>
        public string? PatientEmail { get; set; }

        /// <summary>
        /// Gets or sets the provider mobile.
        /// </summary>
        public string? ProviderMobile { get; set; }

        /// <summary>
        /// Gets or sets the provider email.
        /// </summary>
        public string? ProviderEmail { get; set; }

        /// <summary>Gets or sets the enable email alerts.</summary>
        public bool? EnableEmailAlerts { get; set; }

        /// <summary>Gets or sets the enable sms alerts.</summary>
        public bool? EnableSMSAlerts { get; set; }

        /// <summary>Gets or sets the enable desktop notifications.</summary>
        public bool? EnableDesktopNotifications { get; set; }

        /// <summary>Gets or sets the enable mobile notifications.</summary>
        public bool? EnableMobileNotifications { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient country id.
        /// </summary>
        public int PatientCountryId { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string? PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the provider country id.
        /// </summary>
        public int ProviderCountryId { get; set; }

        /// <summary>
        /// Gets or sets the provider country code.
        /// </summary>
        public string? ProviderCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the visit type.
        /// </summary>
        public char? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the previous appointment date.
        /// </summary>
        public DateTime? AppointmentPreviousDate { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public TimeSpan? AppointmentPreviousTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment date time.
        /// </summary>
        public string? AppointmentDateTime { get; set; }

        /// <summary>
        /// Gets or sets the old appointment date time.
        /// </summary>
        public string? OldAppointmentDateTime { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the appointment notes.
        /// </summary>
        public string? AppointmentNotes { get; set; }

        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int? CouponId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal Amount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public decimal Discount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal Total { get; set; }

        /// <summary>
        /// Gets or sets the app charges.
        /// </summary>
        public decimal AppCharges { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the status name.
        /// </summary>
        public string StatusName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the appointment status id.
        /// </summary>
        public int AppointmentStatusId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public bool IsCc { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public string? EncounterType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is prescription.
        /// </summary>
        public bool IsPrescription { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is full transcript.
        /// </summary>
        public bool IsFullTranscript { get; set; }

        /// <summary>
        /// Gets or sets the patient guid.
        /// </summary>
        public string? PatientGuid { get; set; }

        /// <summary>
        /// Gets or sets the provider guid.
        /// </summary>
        public string? ProviderGuid { get; set; }

        /// <summary>Gets or sets the patient document count.</summary>
        public int? PatientDocumentCount { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? RoomName { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? Domain { get; set; }

        /// <summary>
        /// Gets or sets the symptoms.
        /// </summary>
        public string? Symptoms { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is online.
        /// </summary>
        public bool IsOnline { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Delay { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the log From.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the doctor message count.
        /// </summary>
        public int? DoctorMessageCount { get; set; }

        /// <summary>
        /// Gets or sets the patient message count.
        /// </summary>
        public int? PatientMessageCount { get; set; }

        /// <summary>
        /// Gets or sets the wallet amount.
        /// </summary>
        public decimal? WalletAmount { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public DateTime? CallStatusDate { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public DateTime? CallStatusModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public int? CallStatus { get; set; }

        /// <summary>
        /// Gets or sets the in progress.
        /// </summary>
        /// <value>
        /// The in progress.
        /// </value>
        public bool? InProgress { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public string? CallStatusName { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public int? CallType { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public string? CallTypeName { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public int? CallerCallStatus { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public string? CallerCallStatusName { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public int? ReceiverCallStatus { get; set; }

        /// <summary>
        /// Gets or sets the call type.
        /// </summary>
        public string? ReceiverCallStatusName { get; set; }

        /// <summary>
        /// Gets or sets the caller call status date.
        /// </summary>
        public DateTime? CallerCallStatusDate { get; set; }

        /// <summary>
        /// Gets or sets the caller call status date.
        /// </summary>
        public DateTime? ReceiverCallStatusDate { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine duration.
        /// </summary>
        public int? TelemedicineDuration { get; set; }

        /// <summary>
        /// Gets or sets the is require emergency appointment.
        /// </summary>
        public bool? IsRequireEmergencyAppointment { get; set; }

        /// <summary>
        /// Gets or sets the active users.
        /// </summary>
        public string? ActiveUsers { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine ids.
        /// </summary>
        public string? TelemedicineIds { get; set; }

        /// <summary>
        /// Gets or sets the is utc.
        /// </summary>
        public int? CallerRoleId { get; set; }

        /// <summary>
        /// Gets or sets the is utc.
        /// </summary>
        public bool? IsUTC { get; set; }

        /// <summary>
        /// Gets or sets the is languages.
        /// </summary>
        public string? Languages { get; set; }

        /// <summary>
        /// Gets or sets the is specializations.
        /// </summary>
        public string? Specializations { get; set; }

        /// <summary>
        /// Gets or sets the is specializations.
        /// </summary>
        public bool EnableMobileAudioCall { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is prescription blink.
        /// </summary>
        public bool IsPrescriptionBlink { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is prescription blink.
        /// </summary>
        public bool? IsTaskDone { get; set; }

        /// <summary>
        /// Gets or sets the is no of emails.
        /// </summary>
        public int? NoOfEmails { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether Is panic option.
        /// </summary>
        public bool? IsPanicOption { get; set; }

        /// <summary>
        /// Gets or sets the is umr no.
        /// </summary>
        public string? UMRNo { get; set; }

        /// <summary>
        ///  Gets or sets follow up for AppointmentId.
        /// </summary>
        public int? FollowUpForAppointmentId { get; set; }

        /// <summary>
        ///  Gets or sets follow up for admission id.
        /// </summary>
        public int? FollowUpForAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the follow up days.
        /// </summary>
        public short? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets AadharNo.
        /// </summary>
        public string? AadharNo { get; set; }

        /// <summary>
        /// Gets or sets the Referred by.
        /// </summary>
        public string? ReferredBy { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? ReferredByName { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? PreviousAppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the admission discharge TimeString
        /// </summary>
        public string? PreviousAdmissionDischargeTimeString { get; set; }

        /// <summary>
        /// Gets or sets the admission discharge time.
        /// </summary>
        public TimeSpan AdmissionDischargeTime { get; set; }


        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the FatherOrHusband name.
        /// </summary>
        public string? FatherOrHusband { get; set; }

        /// <summary>
        /// Gets or sets the queue status.
        /// </summary>
        /// <value>
        /// The queue status.
        /// </value>
        public string? QueueStatus { get; set; }


        /// <summary>
        /// Gets or sets the specialization names.
        /// </summary>
        public string? SpecializationNames { get; set; }
      
    }
}
