﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Hims.Shared.Library.Enums;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The account.
    /// </summary>
    public class RegisterModel
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int RegisterId { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the first floor ad.
        /// </summary>
        public string FirstFloorAD { get; set; }

        /// <summary>
        /// Gets or sets the second floor ad.
        /// </summary>
        public string SecondFloorAD { get; set; }

        /// <summary>
        /// Gets or sets the third floor ad.
        /// </summary>
        public string ThirdFloorAD { get; set; }

        /// <summary>
        /// Gets or sets the ff semiprivate ad.
        /// </summary>
        public string FFSemiPrivateAD { get; set; }

        /// <summary>
        /// Gets or sets the ground floor ad.
        /// </summary>
        public string GroundFloorAD { get; set; }

        /// <summary>
        /// Gets or sets the nicu register.
        /// </summary>
        public string NICURegister { get; set; }

        /// <summary>
        /// Gets or sets the nicu delivery register.
        /// </summary>
        public string NICUDeliveryRegister { get; set; }

        /// <summary>
        /// Gets or sets a value mid wife register.
        /// </summary>
        public string MidWifeRegister { get; set; }

        /// <summary>
        /// Gets or sets the daycare ad.
        /// </summary>
        public string DayCareAD { get; set; }

        /// <summary>
        /// Gets or sets a value nicu op register.
        /// </summary>
        public string NICUOpRegister { get; set; }

        /// <summary>
        /// Gets or sets the emergency register.
        /// </summary>
        public string EmergencyRegister { get; set; }

        /// <summary>
        /// Gets or sets the labour ward register.
        /// </summary>
        public string LabourWardRegister { get; set; }

        /// <summary>
        /// Gets or sets the labour ward all register.
        /// </summary>
        public string LabourWardAllRegister { get; set; }

        /// <summary>
        /// Gets or sets a value ot register.
        /// </summary>
        public string OTRegister { get; set; }

        /// <summary>
        /// Gets or sets a ot all register.
        /// </summary>
        public string OTAllRegister { get; set; }

        /// <summary>
        /// Gets or sets a icn register.
        /// </summary>
        public string ICNRegister { get; set; }
        public string ThirdFloorLW { get; set; }
        public string ThirdFloorAllLW { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        public int LocationId { get; set; }
        public bool Active { get; set; }
        public string JsonString { get; set; }
        public RegisterType Type { get; set; }

    }
}