﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels
{
    /// <summary>
    /// The basic bed management availability model.
    /// </summary>
    public class BedManagementAvailabilityModel
    {
        /// <summary>
        /// Gets or sets the floor id.
        /// </summary>
        public int? FloorId { get; set; }

        /// <summary>
        /// Gets or sets the floor name.
        /// </summary>
        public string FloorName { get; set; }

        /// <summary>
        /// Gets or sets the floor name.
        /// </summary>
        public Wards[] Wards { get; set; }
    }

    /// <summary>
    /// The basic bed management availability model.
    /// </summary>
    public class Wards
    {
        /// <summary>
        /// Gets or sets the floor name.
        /// </summary>
        public int? WardId { get; set; }

        /// <summary>
        /// Gets or sets the floor name.
        /// </summary>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the floor name.
        /// </summary>
        public Rooms[] Rooms { get; set; }
    }

    /// <summary>
    /// The basic Rooms model.
    /// </summary>
    public class Rooms
    {
        /// <summary>
        /// Gets or sets the floor name.
        /// </summary>
        public int? RoomId { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the floor name.
        /// </summary>
        public Beds[] Bed { get; set; }
    }

    /// <summary>
    /// The basic Rooms model.
    /// </summary>
    public class Beds
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? BedId { get; set; }

        /// <summary>
        /// Gets or sets the bed number.
        /// </summary>
        public string BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the bed status name.
        /// </summary>
        public string BedStatusName { get; set; }
    }
}