﻿namespace Hims.Shared.UserModels.ChargeManagement
{
    using System;

    /// <summary>
    /// The provider profile info model.
    /// </summary>
    public class FilterModel
    {
        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// Gets or sets the charge group identifier.
        /// </summary>
        /// <value>
        /// The charge group identifier.
        /// </value>
        public string ChargeGroup { get; set; }

        /// <summary>
        /// Gets or sets the charge identifier.
        /// </summary>
        /// <value>
        /// The charge identifier.
        /// </value>
        public string Charge { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Term { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int? ChargeCategoryId { get; set; }
    }
}