﻿namespace Hims.Shared.UserModels.PatientMedication
{
    using System;
    using System.Collections.Generic;
    using Hims.Shared.UserModels.Laboratory;
    using Hims.Shared.UserModels.Labs;

    /// <summary>
    /// The patient medication header model.
    /// </summary>
    public class PatientMedicationHeaderModel
    {
        /// <summary>
        /// Gets or sets the patient medication header identifier.
        /// </summary>
        /// <value>
        /// The patient medication header identifier.
        /// </value>
        public int PatientMedicationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the patient lab header identifier.
        /// </summary>
        /// <value>
        /// The patient lab header identifier.
        /// </value>
        public int? PatientLabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the appointment identifier.
        /// </summary>
        /// <value>
        /// The appointment identifier.
        /// </value>
        public int? AppointmentId { get; set; }

           
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="PatientMedicationHeaderModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the type of the encounter.
        /// </summary>
        /// <value>
        /// The type of the encounter.
        /// </value>
        public string EncounterType { get; set; }

        /// <summary>
        /// Gets or sets the medicines.
        /// </summary>
        /// <value>
        /// The medicines.
        /// </value>
        public List<PatientMedicationDetailModel> Medicines { get; set; }

        ///// <summary>
        ///// Gets or sets the labs.
        ///// </summary>
        ///// <value>
        ///// The labs.
        ///// </value>
        //public List<LabHeaderModel> Labs { get; set; }

        /// <summary>
        /// Gets or sets the labs.
        /// </summary>
        /// <value>
        /// The labs.
        /// </value>
        public List<LabMainDetailModel> Labs { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        /// <value>
        /// The appointment no.
        /// </value>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        /// <value>
        /// The appointment date.
        /// </value>
        public string AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        /// <value>
        /// The appointment time.
        /// </value>
        public string? AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public TimeSpan AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        /// <value>
        /// The patient gender.
        /// </value>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        /// <value>
        /// The patient age.
        /// </value>
        public string PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        /// <value>
        /// The patient mobile.
        /// </value>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the name of the provider.
        /// </summary>
        /// <value>
        /// The name of the provider.
        /// </value>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment identifier.
        /// </summary>
        /// <value>
        /// The encrypted appointment identifier.
        /// </value>
        public string EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }
        /// <summary>
        /// Gets or sets the practice location.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string PracticeLocation { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the provider no.
        /// </summary>
        public string ProviderNo { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the educations.
        /// </summary>
        public string Educations { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is billing done.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is billing done; otherwise, <c>false</c>.
        /// </value>
        public bool? IsBillingDone { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string EncryptedPatientId { get; set; }
        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string StreetAddress { get; set; }
        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string? CityName { get; set; }
        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string? StateName { get; set; }
        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string? CountryName { get; set; }

        /// <summary>
        /// Gets or sets the specialization identifier.
        /// </summary>
        /// <value>
        /// The specialization identifier.
        /// </value>
        public int SpecializationId { get; set; }


    }
}
