﻿

namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;
    using System.Text;
    /// <summary>
    /// The working hour model.
    /// </summary>
    public class WorkingHourModel
    {
        /// <summary>
        /// Gets or sets the working hour id
        /// </summary>
        /// <value>
        /// The working hour id
        /// </value>
        
        public int WorkingHourId { get; set; }
        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>

        public string StartDate { get; set; }
        /// <summary>
        /// Gets or sets the start time.
        /// </summary>
        /// <value>
        /// The start time.
        /// </value>
        public string StartTime { get; set; }
        /// <summary>
        /// Gets or sets end date.
        /// </summary>
        /// <value>
        /// The end time.
        /// </value>
        public string EndDate { get; set; }
        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        /// <value>
        /// The end time.
        /// </value>
        public string EndTime { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="WorkingHour"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string ModifiedByRole { get; set; }
        /// <summary>
        /// Gets or sets the loginId by role.
        /// </summary>
        /// <value>
        /// The loginId by role.
        /// </value>
        public short LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets location Id.
        /// </summary>
        /// <value>
        /// The Id by Location.
        /// </value>
        public int LocationId { get; set; }
    }
}
