﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary> The chat.</summary>
    public class Chat
    {
        /// <summary>Gets or sets the chat id.</summary>
        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        [Key, Identity]
        public int ChatId { get; set; }

        /// <summary>Gets or sets the sender id.</summary>
        public int SenderId { get; set; }

        /// <summary>Gets or sets the sender type.</summary>
        public string SenderType { get; set; }

        /// <summary>Gets or sets the receiver id.</summary>
        public int ReceiverId { get; set; }

        /// <summary>Gets or sets the receiver type.</summary>
        public string ReceiverType { get; set; }

        /// <summary>Gets or sets the created date.</summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>Gets or sets the message.</summary>
        public string Message { get; set; }
    }
}
