﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class Cubicle
    {
        /// <summary>
        /// Gets or sets the widget id.
        /// </summary>
        [Key, Identity]
        public int CubicleId { get; set; }

        /// <summary>
        /// Gets or sets the widget name.
        /// </summary>
        public string Name { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the active status id.
        /// </summary>
        public int ActiveStatusId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the Location id.
        /// </summary>
        public int? LocationId { get; set; }

    }
}
