﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The insurance timeline.
    /// </summary>
    public class InsuranceTimeline
    {
        /// <summary>
        /// Gets or sets the insurance timeline id.
        /// </summary>
        [Key, Identity]
        public int InsuranceTimelineId { get; set; }
       
        /// <summary>
        /// Gets or sets the insurance admission id.
        /// </summary>
        public int InsuranceForAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the attachments.
        /// </summary>
        public string Attachments { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy{ get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate{ get; set; }
    }
}
