﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities.Pharmacy
{
    /// <summary>
    /// The pharmacy department indent header.
    /// </summary>
    public class PharmacyDepartmentIndentHeader
    {
        /// <summary>
        /// Gets or sets the pharmacy department indent header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department indent header identifier.
        /// </value>
        [Key,Identity]
        public long PharmacyDepartmentIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the required date.
        /// </summary>
        /// <value>
        /// The required date.
        /// </value>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="PharmacyDepartmentIndentHeader"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department identifier.
        /// </value>
        public int? PharmacyDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the approved ware house identifier.
        /// </summary>
        /// <value>
        /// The approved ware house identifier.
        /// </value>
        public int? ApprovedWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the approved retail store identifier.
        /// </summary>
        /// <value>
        /// The approved retail store identifier.
        /// </value>
        public int? ApprovedRetailStoreId { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        /// <value>
        /// The reason.
        /// </value>
        public string Reason { get; set; }
    }
}
