﻿namespace Hims.Domain.Entities.Vendors
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The purchase order header.
    /// </summary>
    [Table("PurchaseOrderHeader", Schema = "vendors")]
    public class PurchaseOrderHeader
    {
        /// <summary>
        /// Gets or sets the purchase order header identifier.
        /// </summary>
        /// <value>
        /// The purchase order header identifier.
        /// </value>
        [Key,Identity]
        public long PurchaseOrderHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the po number.
        /// </summary>
        /// <value>
        /// The po number.
        /// </value>
        public string PONumber { get; set; }

        /// <summary>
        /// Gets or sets the po raise date.
        /// </summary>
        /// <value>
        /// The po raise date.
        /// </value>
        public DateTime PORaiseDate { get; set; }

        /// <summary>
        /// Gets or sets the estimated delivery date.
        /// </summary>
        /// <value>
        /// The estimated delivery date.
        /// </value>
        public DateTime? EstimatedDeliveryDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total tax.
        /// </summary>
        /// <value>
        /// The total tax.
        /// </value>
        public double TotalTax { get; set; }

        /// <summary>
        /// Gets or sets the total net amount.
        /// </summary>
        /// <value>
        /// The total net amount.
        /// </value>
        public double TotalNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int PharmacyWareHouseId { get; set; }
    }
}
