﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.Library;
    using Shared.Library.Enums;
    using Shared.UserModels;

    using Hims.Shared.Library.Helpers;

    /// <summary>
    /// The Behavioral Health Service interface.
    /// </summary>
    public interface IBehavioralHealthService
    {
        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAltAsync(BehavioralModifyModel model);

        /// <summary>
        /// The find async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<BehavioralHealthModel> FindAsync(int appointmentId);

        /// <summary>
        /// The find internal medicine async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <param name="type">
        /// The encounter type.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<BehavioralHealthResource> FindDashboardAsync(int appointmentId, BehavioralHealthType type);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(BehavioralModifyModel model);

        /// <summary>
        /// The find prescription async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<BehavioralPrescriptionModel> FindPrescriptionAsync(int appointmentId);

        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<BehavioralHealthFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);
    }
}