﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels.ProviderMedication;

    /// <summary>
    /// The provider medication Service interface.
    /// </summary>
    public interface IProviderMedicationService
    {
        /// <summary>
        /// Adds the provider medication in bulk.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddProviderMedicationInBulk(ProviderMedicationGroupModel model);

        /// <summary>
        /// Fetches the added medication asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ProviderMedicationMasterModel>> FetchAddedMedicationAsync(ProviderMedicationMasterModel model);

        /// <summary>
        /// Gets all tags asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<string>> GetAllTagsAsync();

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        /// 

        //Task<int> UpdateAsync(ProviderMedicationMasterModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="providerMedicationMasterId">
        /// The specialization id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int? providerMedicationMasterId);
    }
}
