﻿using Hims.Shared.UserModels.Receipt;

namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using ReceiptTypes = Hims.Shared.UserModels.Receipt.ReceiptTypePayload;

    /// <summary>
    /// The receipt service
    /// </summary>
    public interface IReceiptService
    {
        /// <summary>
        /// Cancels the asynchronous.
        /// </summary>
        /// <param name="receiptId">The receipt identifier.</param>
        /// <returns></returns>
        Task<int> CancelAsync(int receiptId);

        /// <summary>
        /// Fetches the receipt types asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<ReceiptTypes.ViewModel>> FetchReceiptTypesAsync();

        /// <summary>
        /// Adds the specified model.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Fetch Receipt details model.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<ViewModel> FetchReceiptDetailsAsync(InsertModel model);

        /// <summary>
        /// Fetches this instance.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);
    }
}
