﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.UserModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class FeedbackDetailsServices : IFeedbackDetailsService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IBedService" />   
        public FeedbackDetailsServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;
        public async Task<int> AddAsync(FeedbackDetails model)
        {
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""PatientName"") FROM ""FeedbackDetails"" WHERE ""MobileNumber"" = '{model.MobileNumber}'");
            if (checkIf > 0)
            {
                return -1;
            }
            if(model.MobileNumber == "" )
            {
                return-1;
            }


            var problem = new FeedbackDetails
            {
                IsActive = true,
                MobileNumber = model.MobileNumber,
                PatientName = model.PatientName,
                Rating = model.Rating,
                Comments = model.Comments,
                Type = model.Type,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,
            };

            return await this.unitOfWork.Feedbackdetails.InsertAsync(problem);
        }

        public Task<int> DeleteAsync(int Id)
        {
            var query = $@"DELETE FROM ""FeedbackDetails"" WHERE ""Id""= {Id}";
            return this.unitOfWork.Current.ExecuteAsync(query);
        }

        public async Task<IEnumerable<FeedbackDetailsModel>> FetchAsync(FeedbackDetailsModel model)
        {
            var query = $@"Select Acc.""FullName"", FD.""MobileNumber"",FD.""PatientName"", FD.""Comments"", FD.""CreatedDate"", FD.""Rating"" From ""FeedbackDetails"" FD Join ""Account"" Acc On FD.""CreatedBy"" = Acc.""AccountId"" order by FD.""Id"" desc";
            var response = await this.unitOfWork.Current.QueryAsync<FeedbackDetailsModel>(query);
            return response;
        }

        public async Task<IEnumerable<FeedbackDetailsModel>> FindById(string Id)
        {
            //var query = $@"SELECT * FROM ""Patient"" WHERE ""Mobile""= '{Id}' and ""HowDidYouKnowId"" = 11 and ""TempPatient"" = false";
            var query = $@"Select Acc.""FullName"", FD.""MobileNumber"",FD.""PatientName"", FD.""Comments"", FD.""CreatedDate"", FD.""Rating"" From ""FeedbackDetails"" FD Join ""Account"" Acc On FD.""CreatedBy"" = Acc.""AccountId""  WHERE FD.""MobileNumber""= '{Id}' order by FD.""Id"" desc ";
            var response = await this.unitOfWork.Current.QueryAsync<FeedbackDetailsModel>(query);
            return response;
        }

        public async Task<int> UpdateAsync(FeedbackDetails model)
        {
            var problems = await this.unitOfWork.Feedbackdetails.FindAsync(m => m.MobileNumber == model.MobileNumber);
            if (model.MobileNumber != "") { problems.MobileNumber = model.MobileNumber; }
            if (model.Rating != 0) { problems.Rating = model.Rating; }
            if (model.Comments != null) { problems.Comments = model.Comments; }
            problems.ModifiedBy = model.ModifiedBy;
            problems.ModifiedDate = DateTime.Now;
            return await this.unitOfWork.Feedbackdetails.UpdateAsync(problems);
        }
    }
}
