﻿import { HTTP_INTERCEPTORS } from "@angular/common/http";
import { ModuleWithProviders, NgModule } from "@angular/core";
import { RequestInterceptor } from "@shared/interceptors";
import { AppointmentRefreshService, AppointmentToggleService, BannerService, BillNotificationService, CommunicationService, DashboardService, FinalBillService, HttpErrorService, HttpService, IconService, IdentityService, JitsiService, MenuService, NotifyService, PrintOptionService, PrintService, QueueService, RedirectAppointmentService, ResourceService, SettingService, TimelineToggleService, ValidatorService, VideoLinkService } from "@shared/services";
import { SharedCommonModule } from "@shared/shared.common.module";
import { SharedLibsModule } from "@shared/shared.libs.module";
import { SharedService } from "./services/shared.service";

@NgModule({
    imports: [SharedCommonModule, SharedLibsModule],
    exports: [SharedCommonModule, SharedLibsModule]
})
export class SharedModule {
    static forRoot(): ModuleWithProviders<SharedModule> {
        return {
            ngModule: SharedModule,
            providers: [
                TimelineToggleService, CommunicationService, VideoLinkService, AppointmentToggleService, IdentityService, NotifyService, HttpService, ResourceService, JitsiService, QueueService, ValidatorService, FinalBillService, MenuService, PrintService, HttpErrorService, DashboardService, SettingService, AppointmentRefreshService, RedirectAppointmentService, PrintOptionService, BannerService, IconService, SharedService, BillNotificationService,
                {
                    provide: HTTP_INTERCEPTORS,
                    useClass: RequestInterceptor,
                    multi: true
                }
            ]
        };
    }
}
