﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The appointment support log.
    /// </summary>
    public class AppointmentSupportLog
    {
        /// <summary>
        /// Gets or sets the appointment support log id.
        /// </summary>
        [Key, Identity]
        public long AppointmentSupportLogId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        [IgnoreUpdate]
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the assignee id.
        /// </summary>
        public int? AssigneeId { get; set; }

        /// <summary>
        /// Gets or sets the audio.
        /// </summary>
        public string Audio { get; set; }

        /// <summary>
        /// Gets or sets the video.
        /// </summary>
        public string Video { get; set; }

        /// <summary>
        /// Gets or sets the document.
        /// </summary>
        public string Document { get; set; }

        /// <summary>
        /// Gets or sets the invoice.
        /// </summary>
        public string Invoice { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the call status.
        /// </summary>
        public string CallStatus { get; set; }
    }
}
