﻿namespace Hims.Domain.Entities.Labs
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The lab parameter model.
    /// </summary>
    public class LabParameterMethod
    {
        /// <summary>
        /// Gets or sets the lab parameter method identifier.
        /// </summary>
        /// <value>
        /// The lab parameter method identifier.
        /// </value>
        [Key, Identity]
        public int LabParameterMethodId { get; set; }

        /// <summary>
        /// Gets or sets the name of the method.
        /// </summary>
        /// <value>
        /// The name of the method.
        /// </value>
        public string MethodName { get; set; }
    }
}
