﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Laboratory;

    /// <summary>
    /// The laboratory service package interface.
    /// </summary>
    public interface ILaboratoryPackageService
    {
        /// <summary>
        /// The modify lab package.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> ModifyLabPackage(AddBooking model);

        /// <summary>
        /// The fetch all lab packages.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<LabPackageModel>> FetchAllLabPackages(LabPackageModel model);


        /// <summary>
        /// The fetch all lab packages.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<LabPackageModel>> FetchImportLabPackages(LabPackageModel model);

        /// <summary>
        /// The fetch lab package details.
        /// </summary>
        /// <param name="labPackageId">
        /// The lab package id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<LabPackageDetailModel>> FetchLabPackageDetails(int labPackageId);

        /// <summary>
        /// The delete lab package async.
        /// </summary>
        /// <param name="labPackageId">
        /// The lab package id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> DeleteLabPackageAsync(int labPackageId, int? locationId);

        /// <summary>
        /// The fetch lab booking package async.
        /// </summary>
        /// <param name="labBookingHeaderId">
        /// The lab booking header id.
        /// </param>
        /// <param name="labBookingDetailId">
        /// The lab booking detail id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<LabBookingDetailModel>> FetchLabBookingPackageAsync(int labBookingHeaderId, int? labBookingDetailId);

        /// <summary>
        /// The fetch labs inside package booking async.
        /// </summary>
        /// <param name="labBookingDetailId">
        /// The lab booking detail id.
        /// </param>
        /// <param name="labBookingPackageDetailId">
        /// The lab booking package detail id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<BookingPackageLaboratoryModel>> FetchLabsInsidePackageBookingAsync(int labBookingDetailId, int? labBookingPackageDetailId);

        ///// <summary>
        ///// The update lab booking status for sample.
        ///// </summary>
        ///// <param name="model">
        ///// The model
        ///// </param>
        ///// <returns>
        ///// The <see cref="Task"/>
        ///// </returns>
        //Task<int> UpdateLabBookingStatusForSample(RequestLaboratory model);

        ///// <summary>
        ///// The update lab booking package status for sample.
        ///// </summary>
        ///// <param name="model">
        ///// The model
        ///// </param>
        ///// <returns>
        ///// The <see cref="Task"/>
        ///// </returns>
        //Task<int> UpdateLabBookingPackageStatusForSample(RequestLaboratory model);

        /// <summary>
        /// The fetch lab result report parameter package async.
        /// </summary>
        /// <param name="labBookingDetailId">
        /// The lab booking detail id.
        /// </param>
        /// <param name="labBookingPackageDetailId">
        /// The lab booking package detail id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<LabReportParamModel>> FetchLabResultReportParameterPackageAsync(int labBookingDetailId, int labBookingPackageDetailId);

        /// <summary>
        /// The verify lab booking package async.
        /// </summary>
        /// <param name="verifiedBy">
        /// The verified by.
        /// </param>
        /// <param name="labBookingDetailId">
        /// The lab booking detail id.
        /// </param>
        /// <param name="labBookingPackageDetailId">
        /// The lab booking package detail id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> VerifyLabBookingPackageAsync(int verifiedBy, int? labBookingDetailId, int? labBookingPackageDetailId);


        /// <summary>
        /// The update booking lab detail status.
        /// </summary>
        /// <param name="model">
        /// The model
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> UpdateSelectedLab(LabSample model);

        /// <summary>
        /// The modify lab package.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> ModifyImportPackage(PackageImportModel model);

        ///// <summary>
        ///// The update barcode for package's sample.
        ///// </summary>
        ///// <param name="model">
        ///// The model
        ///// </param>
        ///// <returns>
        ///// The <see cref="Task"/>
        ///// </returns>

        //Task<int> UpdatePackageLabForBarcodeAsync(RequestLaboratory model);

        ///// <summary>
        ///// The update booking lab detail status.
        ///// </summary>
        ///// <param name="loginId">
        ///// The id.
        ///// </param>
        ///// <param>
        ///// <param name="labBookingPackageDetailId">
        ///// The id.
        ///// </param>
        ///// <returns>
        ///// The <see cref="Task"/>
        ///// </returns>
        //Task<int> UpdateSampleReceivedStatus(int loginId, int labBookingPackageDetailId);
    }
}
