﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels.Pharmacy;

    /// <summary>
    /// The pharmacy department service interface.
    /// </summary>
    public interface IPharmacyDepartmentService
    {
        /// <summary>
        /// Modifies the department.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyDepartment(PharmacyDepartmentModel model);

        /// <summary>
        /// Fetches the pharmacy department asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDepartmentModel>> FetchPharmacyDepartmentAsync(PharmacyDepartmentModel model);

        /// <summary>
        /// Fetches the departmental stocks.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDepartmentalStockModel>> FetchDepartmentalStocks(PharmacyDepartmentalStockModel model);

        /// <summary>
        /// Adds the pharmacy product additional details asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddPharmacyProductAdditionalDetailsAsync(PharmacyProductDetailModel model);
        
        /// <summary>
        /// Adds the department stock consumption asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddDepartmentStockConsumptionAsync(DepartmentConsumptionModel model);

        /// <summary>
        /// Fetches the departmental consumptions asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DepartmentConsumptionModel>> FetchDepartmentalConsumptionsAsync(DepartmentConsumptionModel model);

        /// <summary>
        /// Fetches the departmental consumption products asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DepartmentConsumptionModel>> FetchDepartmentalConsumptionProductsAsync(DepartmentConsumptionModel model);

        /// <summary>
        /// Fetches the rack department wise asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyProductRackModel>> FetchRackDepartmentWiseAsync(PharmacyProductRackModel model);
        /// <summary>
        /// modifying the department status
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateDepartment(PharmacyDepartmentModel model);

        /// <summary>
        /// Fetches all pharmacy department without users asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyDepartmentModel>> FetchAllPharmacyDepartmentWithoutUsersAsync(PharmacyDepartmentModel model);
    }
}
