﻿namespace Hims.Domain.EntityModels
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The visit type.
    /// </summary>
    public class ChargeCategoryModel
    {
        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int? ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string ChargeCategoryName { get; set; }

        /// <summary>
        /// Gets or sets the charge name.
        /// </summary>
        public int LocationId { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string? ModifiedByName { get; set; }
        
        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string LocationNames { get; set; }
        
        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the default.
        /// </summary>
        /// <value>
        /// The default.
        /// </value>
        public bool? Default { get; set; }

        /// <summary>
        /// Gets or sets the roomcharge Id name.
        /// </summary>
        public int? RoomChargeId { get; set; }

        /// <summary>
        /// Gets or sets the cost/charges to category.
        /// </summary>
        public double? Cost { get; set; }

        /// <summary>
        /// Gets or sets the login role
        /// </summary>
        public short? LoginRoleId { get; set; }
        
    }
}
