﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The coupon filter model.
    /// </summary>
    public class InventoryPurchaseRegisteryFilterModel
    {
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string? SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string? PurchaseBillNo { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public string? BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string? BillType { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int? SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the InventoryWareHouse.
        /// </summary>
        public string? Name { get; set; }

        /// <summary>
        /// Gets or sets the InventoryWareHouse id.
        /// </summary>
        public int? WareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy bill type
        /// </summary>
        public bool? pharmacyBillType { get; set; }

        /// <summary>
        /// Gets or sets the Created By.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the due date.
        /// </summary>
        public string? DueDate { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int LocationId { get; set; }

    }
}
