﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacy issue detail.
    /// </summary>
    public class PharmacyIssueDetail
    {
        /// <summary>
        /// Gets or sets the pharmacy issue detail id.
        /// </summary>
        [Key, Identity]
        public int PharmacyIssueDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy issue header id.
        /// </summary>
        public int PharmacyIssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the retail stock id.
        /// </summary>
        public int RetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the gst percentage.
        /// </summary>
        public double GstPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the gst amount.
        /// </summary>
        public double GstAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy indent detail identifier.
        /// </value>
        public int? PharmacyIndentDetailId { get; set; }
    }
}
