﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Pharmacy;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The PharmacyTrackingService interface.
    /// </summary>
    public interface IPharmacyTrackingService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ProductModel>> FetchPharmacyProducts();


        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyPurchaseReportBill>> FetchPurchaseAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyStockDetailModel>> FetchStocksAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacySaleBill>> FetchRetailStoreSaleAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyRetailDetailModel>> FetchRetailStoreIssuedSaleAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyPurchaseReturnBillModel>> FetchPurchasedReturnAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacySaleReturnBillDetailsModel>> FetchSoldReturnAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacySaleReturnBillDetailsModel>> FetchRetailToMainMovedAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyStockDetailModel>> FetchRetailRecordAsync(PharmacyPurchaseReportBill model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyPurchaseReportBill>> FetchWareHouseRecordAsync(PharmacyPurchaseReportBill model);
    }
}
