﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Shared.EntityModels;

    /// <summary>
    /// The Provider Leave Service interface.
    /// </summary>
    public interface IProviderLeaveService
    {
        /// <summary>
        /// The check async.
        /// </summary>
        /// <param name="leaveDate">
        /// The leave date.
        /// </param>
        /// <param name="providerId">
        /// The provider id.
        /// </param>
        /// <param name="providerLocationId">
        /// The provider location id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CheckAsync(string leaveDate, int providerId, int providerLocationId);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(ProviderLeaveModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(ProviderLeaveModel model);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="providerLeaveId">
        /// The provider leave id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int providerLeaveId);
    }
}
