﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;

    /// <summary>
    /// The Validator Service interface.
    /// </summary>
    public interface IValidatorService
    {
        /// <summary>
        /// The validate email async.
        /// </summary>
        /// <param name="query">
        /// The query.
        /// </param>
        /// <param name="type">
        /// The type.
        /// </param>
        /// <param name="referenceId">
        /// The reference Id.
        /// </param>
        /// <returns>
        /// The boolean.
        /// </returns>
        Task<int> ValidateEmailAsync(string query, string type, int referenceId);

        /// <summary>
        /// The validate mobile async.
        /// </summary>
        /// <param name="query">
        /// The query.
        /// </param>
        /// <param name="countryId">
        /// The country Id.
        /// </param>
        /// <param name="type">
        /// The type.
        /// </param>
        /// <param name="referenceId">
        /// The reference id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ValidateMobileAsync(string query, int countryId, string type, int referenceId);

        /// <summary>
        /// The validate npi async.
        /// </summary>
        /// <param name="query">
        /// The query.
        /// </param>
        /// <param name="providerId">
        /// The provider Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ValidateNpiAsync(string query, int providerId);

        /// <summary>
        /// Validates the pharmacy product asynchronous.
        /// </summary>
        /// <param name="query">The query.</param>
        /// <param name="pharmacyProductId">The pharmacy product id.</param>
        /// <returns></returns>
        Task<int> ValidatePharmacyProductAsync(string query, int? pharmacyProductId);


        /// <summary>
        /// The validate username async.
        /// </summary>
        /// <param name="query">
        /// The query.
        /// </param>
        /// <param name="type">
        /// The type.
        /// </param>
        /// <param name="referenceId">
        /// The reference Id.
        /// </param>
        /// <returns>
        /// The boolean.
        /// </returns>
        Task<int> ValidateUserNameAsync(string query, string type, int referenceId);
    }
}