﻿#nullable enable
namespace Hims.Shared.UserModels.OperationTheater
{
    using System;

    /// <summary>
    /// The reschedule appointment request.
    /// </summary>
    public class RescheduleOTAppointmentRequest
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int OTRegisterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment notes.
        /// </summary>
        public string? AppointmentNotes { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }
        
        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public DateTime AppointmentTime { get; set; } 

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }
        
        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public DateTime AppointmentEndTime { get; set; } 

        /// <summary>
        /// /Gets or sets the scan machine master id.
        /// </summary>
        public int OTRoomId { get; set; }
    }
}
