﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary> The chat.</summary>
    public class Discharge
    {
        /// <summary>
        /// Gets or sets the discharge identifier.
        /// </summary>
        /// <value>
        /// The discharge identifier.
        /// </value>
        [Key, Identity]
        public int DischargeId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        /// <value>
        /// The discharge date.
        /// </value>
        public DateTime DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge time.
        /// </summary>
        /// <value>
        /// The discharge time.
        /// </value>
        public TimeSpan DischargeTime { get; set; }

        /// <summary>
        /// Gets or sets the condition on discharge.
        /// </summary>
        /// <value>
        /// The condition on discharge.
        /// </value>
        public string ConditionOnDischarge { get; set; }

        /// <summary>
        /// Gets or sets the final diagnosis.
        /// </summary>
        /// <value>
        /// The final diagnosis.
        /// </value>
        public string FinalDiagnosis { get; set; }

        /// <summary>
        /// Gets or sets the history of illness.
        /// </summary>
        /// <value>
        /// The history of illness.
        /// </value>
        public string HistoryOfIllness { get; set; }

        /// <summary>
        /// Gets or sets the diet.
        /// </summary>
        /// <value>
        /// The diet.
        /// </value>
        public string Diet { get; set; }

        /// <summary>
        /// Gets or sets the discharge summary.
        /// </summary>
        /// <value>
        /// The discharge summary.
        /// </value>
        public string DischargeSummary { get; set; }

        /// <summary>
        /// Gets or sets the discharge follow up date.
        /// </summary>
        /// <value>
        /// The discharge follow up date.
        /// </value>
        public DateTime? DischargeFollowUpDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge follow up days.
        /// </summary>
        /// <value>
        /// The discharge follow up days.
        /// </value>
        public int? DischargeFollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the follow up summary.
        /// </summary>
        /// <value>
        /// The follow up summary.
        /// </value>
        public string FollowUpSummary { get; set; }

        /// <summary>
        /// Gets or sets the discharge status identifier.
        /// </summary>
        /// <value>
        /// The discharge status identifier.
        /// </value>
        public int DischargeStatusId { get; set; }

        /// <summary>
        /// Gets or sets the is death.
        /// </summary>
        /// <value>
        /// The is death.
        /// </value>
        public bool? IsDeath { get; set; }

        /// <summary>
        /// Gets or sets the death date.
        /// </summary>
        /// <value>
        /// The death date.
        /// </value>
        public DateTime? DeathDate { get; set; }

        /// <summary>
        /// Gets or sets the death time.
        /// </summary>
        /// <value>
        /// The death time.
        /// </value>
        public TimeSpan? DeathTime { get; set; }

        /// <summary>
        /// Gets or sets the cause of death.
        /// </summary>
        /// <value>
        /// The cause of death.
        /// </value>
        public string CauseOfDeath { get; set; }

        /// <summary>
        /// Gets or sets the discharge instruction identifier.
        /// </summary>
        /// <value>
        /// The discharge instruction identifier.
        /// </value>
        public string DischargeInstructionId { get; set; }


        ///// <summary>
        ///// Gets or sets the discharge instruction name.
        ///// </summary>
        ///// <value>
        ///// The discharge instruction name.
        ///// </value>
        //public string? DischargeInstructionName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="Discharge"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }


        ///// <summary>
        ///// Gets or sets the discharge instruction name.
        ///// </summary>
        ///// <value>
        ///// The discharge instruction name.
        ///// </value>
        //public string? DischargeInstructionName { get; set; }

        /// <summary>
        /// Gets or sets the history of illness.
        /// </summary>
        /// <value>
        /// The Past history.
        /// </value>
        public string PastHistory { get; set; }

        /// <summary>
        /// Gets or sets the history of illness.
        /// </summary>
        /// <value>
        /// Advise
        /// </value>
        public string DischargeAdvise { get; set; }

        /// <summary>
        /// Gets or sets the history of illness.
        /// </summary>
        /// <value>
        /// The Surgery Details.
        /// </value>
        public string Surgery { get; set; }

        /// <summary>
        /// Gets or sets list of surgoen name.
        /// </summary>
       // public Array? SurgeonName { get; set; } = null;

        /// <summary>
        /// Gets or sets the GeneralExamination.
        /// </summary>
        public string GeneralExamination { get; set; }

        /// <summary>
        /// Gets or sets the LocalExamination.
        /// </summary>
        public string LocalExamination { get; set; }

        /// <summary>
        /// Gets or sets the HospitalCourse.
        /// </summary>
        public string HospitalCourse { get; set; }


        /// <summary>
        /// Gets or sets the OperativeProcedure.
        /// </summary>
        public string OperativeProcedure { get; set; }


        /// <summary>
        /// Gets or sets the OperativeNotes.
        /// </summary>
        public string OperativeNotes { get; set; }

        /// <summary>
        /// Gets or sets the ConsultantSignature by provider.
        /// </summary>
        /// <value>
        /// The providerid of provider.
        /// </value>
        public int? ConsultantSignature { get; set; }
    }
}
