﻿namespace Hims.Domain.Entities.Inventory
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The inventory departental stock
    /// </summary>
    public class InventoryDepartmentalStock
    {
        /// <summary>
        /// Gets or sets the inventory departmental stock identifier.
        /// </summary>
        /// <value>
        /// The inventory departmental stock identifier.
        /// </value>
        [Key, Identity]
        public int InventoryDepartmentalStockId { get; set; }

        /// <summary>
        /// Gets or sets the inventory product identifier.
        /// </summary>
        /// <value>
        /// The inventory product identifier.
        /// </value>
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax identifier.
        /// </summary>
        /// <value>
        /// The tax identifier.
        /// </value>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        /// <value>
        /// The quantity in.
        /// </value>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        /// <value>
        /// The quantity out.
        /// </value>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the inventory stock identifier.
        /// </summary>
        /// <value>
        /// The inventory stock identifier.
        /// </value>
        public int InventoryStockId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        /// <value>
        /// The expiry date.
        /// </value>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the inventory department identifier.
        /// </summary>
        /// <value>
        /// The inventory department identifier.
        /// </value>
        public int InventoryDepartmentId { get; set; }
    }
}
