﻿namespace Hims.Domain.Entities.Labs
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The lab template detail.
    /// </summary>
    public class LabTemplateDetail
    {
        /// <summary>
        /// Gets or sets the lab template detail identifier.
        /// </summary>
        /// <value>
        /// The lab template detail identifier.
        /// </value>
        [Key, Identity]
        public int LabTemplateDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab component header identifier.
        /// </summary>
        /// <value>
        /// The lab component header identifier.
        /// </value>
        public int? LabComponentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter header identifier.
        /// </summary>
        /// <value>
        /// The lab parameter header identifier.
        /// </value>
        public int? LabParameterHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public int Priority { get; set; }
    }
}
