﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Pharmacy;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <inheritdoc />
    public class PharmacyTrackingServices : IPharmacyTrackingService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <summary>
        /// Initializes a new instance of the <see cref="AuditLogServices"/> class.
        /// </summary>
        /// <param name="unitOfWork">
        /// The unit of work.
        /// </param>
        public PharmacyTrackingServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc/>
        public async Task<IEnumerable<ProductModel>> FetchPharmacyProducts()
        {
            //var where = $@"WHERE 1=1 ";
            //if (!String.IsNullOrEmpty(model.Barcode))
            //{
            //    where += $@" AND PPD.""Barcode"" = '{model.Barcode}'";
            //}
            var query =
                $@"SELECT Distinct on(PP.""PharmacyProductId"")
                      --  count(PP.*) over() as ""TotalItems"", 
                                PP.""PharmacyProductId"", PP.""ProductName"", PP.""MaxQuantity"", PP.""MinQuantity"", PP.""RolQuantity"", PP.""GenericName"", 
                                    PP.""Barcode"",PP.""PurchaseUnitQty"", PP.""SaleUnitQty"", PP.""CategoryId"", PP.""CompanyId"", PP.""SupplierId"", PP.""PurchaseUnit"",
                                    PP.""SaleUnit"", PP.""TaxId"",PP.""RackId"", PP.""IsProductExpire"", PP.""Active"", PP.""CreatedBy"", PP.""CreatedDate"",
                                    C.""Name"" as ""CompanyName"",Cat.""Name"" as ""CategoryName"",Tax.""Name"" as ""Tax"",Rack.""Name"" as ""RackName"",
                                    PurchaseUnit.""Name"" as ""PurchaseUnitName"", SaleUnit.""Name"" as ""SaleUnitName"",
                                    A.""FullName"" as ""CreatedByName""
	                                    FROM ""PharmacyProduct"" PP join ""Company"" C on C.""CompanyId"" = PP.""CompanyId""
	                                    join ""LookupValue"" Cat on Cat.""LookupValueId"" = PP.""CategoryId""
	                                  left  join ""LookupValue"" Tax on Tax.""LookupValueId"" = PP.""TaxId""
	                                    left join ""LookupValue"" Rack on Rack.""LookupValueId"" = PP.""RackId""
	                                    left join ""LookupValue"" PurchaseUnit on PurchaseUnit.""LookupValueId"" = PP.""PurchaseUnit""
	                                  left  join ""LookupValue"" SaleUnit on SaleUnit.""LookupValueId"" = PP.""SaleUnit""
	                                    join ""Account"" A on A.""AccountId"" = PP.""CreatedBy""
                                    join ""PharmacyPurchaseDetail"" PPD on PP.""PharmacyProductId""=PPD.""PharmacyProductId""                              
                                      
                                            ";

            return await this.unitOfWork.Current.QueryAsync<ProductModel>(query);
        }

        public async  Task<IEnumerable<PharmacyPurchaseReportBill>> FetchPurchaseAsync(PharmacyPurchaseReportBill model)
        {
            var where= $@"WHERE 1=1 ";
            if (model.PharmacyProductId != null)
            {
                where += $@" AND PPD.""PharmacyProductId"" = {model.PharmacyProductId}";
            }
            if (!string.IsNullOrEmpty(model.BatchNumber))
            {
                where += $@" and PS.""BatchNumber"" ilike '%{model.BatchNumber}%' ";
            }
            if (!string.IsNullOrEmpty(model.Barcode))
            {
                where += $@" and PS.""Barcode"" = '{model.Barcode}' ";
            }
            var query = $@"SELECT 
                                 PWH.""WareHouseName"",
                             PPH.""PharmacyPurchaseHeaderId"",
                                PPH.""BillNumber"",
		                        PPH.""BillType"",
		                        PPH.""BillDate"", 
                               -- PPH.""SupplierId"",
                                       S.""Name"" as ""SupplierName"",
                                PPH.""CreatedDate"",
                                    CA.""FullName"" as ""CreatedByName"",	 
									CR.""RoleName"" ,
                            PPD.""PharmacyPurchaseDetailId"", PPD.""Free"", -- for specific product 
                             --  PPD.""PharmacyProductId"",
                                     PP.""ProductName"",-- PP.""Barcode"", PP.""IsProductExpire"",
                               PPD.""Quantity"",
                               PPD.""PurchaseRate"", PPD.""Mrp"", PPD.""TaxAmount"", PPD.""DiscountAmount"" as ""Discount"",
                              -- PPD.""PharmacyStockId"",
                                     PS.""BatchNumber"", PS.""ExpiryDate"",PS.""QuantityIn"",PS.""QuantityOut"",
                                      PS.""Barcode"",
                                     (PS.""QuantityIn"" - PS.""QuantityOut"") as ""AvailableQuantity"",
									 PS.""PurchaseRate"" as ""PurchaseRateUnit"",
									 PS.""Mrp"" as ""MrpUnit"",
                               PPD.""NetAmount"" ,
							  PPD.""Total"" 

                            from ""PharmacyProduct"" PP
                            left join ""PharmacyPurchaseDetail"" PPD on PPD.""PharmacyProductId"" = PP.""PharmacyProductId""
                             left join ""PharmacyPurchaseHeader"" PPH on PPH.""PharmacyPurchaseHeaderId"" = PPD.""PharmacyPurchaseHeaderId""
                             left join ""PharmacyStock"" PS on PS.""PharmacyStockId"" = PPD.""PharmacyStockId""                      
                            left join ""Supplier"" S on S.""SupplierId""=PPH.""SupplierId""
                             left join ""Account"" CA on CA.""AccountId"" = PPH.""CreatedBy""
                             left join ""Role"" CR on CA.""RoleId"" = CR.""RoleId""
                            left join ""PharmacyWareHouse"" PWH on PWH.""PharmacyWareHouseId""=PPH.""PharmacyWareHouseId""
                                    { where}                          
                                    Order by PPH.""BillDate"" desc";
                            								                        
            return await this.unitOfWork.Current.QueryAsync<PharmacyPurchaseReportBill>(query);
            //--where PPD.""PharmacyProductId"" = { pharmacyProductId}
        }

        public async Task<IEnumerable<PharmacyStockDetailModel>> FetchStocksAsync(PharmacyPurchaseReportBill model)
        {
            var where = $@"WHERE 1=1";
            //if (batchNumber != "null")
            //{
            //    where += $@" AND PRS.""BatchNumber"" ='{batchNumber}'";
            //}
            if (model.PharmacyProductId != null)
            {
                where += $@" AND PP.""PharmacyProductId"" = {model.PharmacyProductId}";
            }
            if (!string.IsNullOrEmpty(model.BatchNumber))
            {
                where += $@" and PRS.""BatchNumber"" ilike '%{model.BatchNumber}%' ";
            }
            if (!string.IsNullOrEmpty(model.Barcode))
            {
                where += $@" and PRS.""Barcode"" = '{model.Barcode}' ";
            }
            var query = $@"SELECT  
	                          INH.""IndentHeaderId"", 
                                  INA.""FullName"" as ""IndentByName"",	 
                                  INR.""RoleName"" as ""IndentByRoleName"",
                             INH.""CreatedDate"" as ""IndentDate"", 
                             INH.""RequiredDate"", 
	                    	 IND.""IndentDetailId"",                                   
	                    	 IND.""Quantity"" as ""IndentQty"", 
                                    RP.""RetailPharmacyId"",RP.""RetailName"", 
	                        ISH.""IssueHeaderId"" , 
                                     ISA.""FullName"" as ""IssueByName"",	 
							        ISR.""RoleName"" as ""IssueByRoleName"",
	                        ISH.""CreatedDate"" as ""IssueDate"" ,                            
		                    ISD.""IssueDetailId"",
		                    ISD.""Quantity"" as ""IssueQty"",PS.""BatchNumber"",PS.""ExpiryDate"",
	                    --   PS.""PharmacyStockId"",,PS.""QuantityIn"",PS.""QuantityOut"" ,
                                -- PRS.""PharmacyStockId"",PRS.""BatchNumber"",PRS.""ExpiryDate"",PRS.""QuantityIn"",PRS.""QuantityOut"" ,
							    --  (PRS.""QuantityIn"" - PRS.""QuantityOut"") as ""AvailableQuantity"",
	                        PP.""PharmacyProductId"",PWH.""WareHouseName""
                            from ""PharmacyProduct"" PP
                            JOIN ""IssueDetail"" ISD ON ISD.""ProductId"" = PP.""PharmacyProductId""
                            JOIN ""IssueHeader"" ISH ON ISH.""IssueHeaderId"" = ISD.""IssueHeaderId""

                                JOIN ""IndentHeader"" INH ON INH.""IndentHeaderId"" = ISH.""IndentHeaderId""
                                JOIN ""IndentDetail"" IND ON(IND.""IndentHeaderId"" = INH.""IndentHeaderId"" AND IND.""ProductId"" = PP.""PharmacyProductId"")
                                Join  ""RetailPharmacy""  RP on RP.""RetailPharmacyId"" = INH.""RetailPharmacyId""
                                join ""PharmacyStock""  PS on PS.""PharmacyStockId"" = ISD.""StockId""
                               -- join ""PharmacyRetailStock""  PRS on PRS.""PharmacyStockId"" = ISD.""StockId""
                                join ""Account"" INA on INA.""AccountId"" = INH.""CreatedBy""
                                join ""Role"" INR on INA.""RoleId"" = INR.""RoleId""
                                left join ""Account"" ISA on ISA.""AccountId"" = ISH.""CreatedBy""
                                left join ""Role"" ISR on ISA.""RoleId"" = ISR.""RoleId""
                                join ""PharmacyWareHouse"" PWH on PWH.""PharmacyWareHouseId""=PS.""PharmacyWareHouseId""
                                        { where}
                                 Order by INH.""CreatedDate"" desc";           
            
            return await this.unitOfWork.Current.QueryAsync<PharmacyStockDetailModel>(query);

        }

        public  async Task<IEnumerable<PharmacySaleBill>> FetchRetailStoreSaleAsync(PharmacyPurchaseReportBill model)
        {
            var where = $@"WHERE 1=1 ";
            if (model.PharmacyProductId != null)
            {
                where += $@" AND  PP.""PharmacyProductId"" = {model.PharmacyProductId}";
            }
            if (!String.IsNullOrEmpty(model.BatchNumber))
            {
                where += $@" AND PRS.""BatchNumber"" ilike '%{model.BatchNumber}%'";
            }
            if (!string.IsNullOrEmpty(model.Barcode))
            {
                where += $@" and PRS.""Barcode"" = '{model.Barcode}' ";
            }
            var query = $@"select  
		                    RP.""RetailPharmacyId"",
                            RP.""RetailName"",
			                    PSH.""PharmacySaleHeaderId"",
			                    PSH.""BillNumber"",
			                    PSH.""SaleDate"",
			                    PSH.""PatientId"",PSH.""PatientName"",PSH.""Mobile"",
                            --    PSH.""Total"",PSH.""OverallDiscount"",
                             --   PSH.""OverallNetAmount"",       
		                    PSD.""PharmacySaleDetailId"",
		                    PSD.""PharmacyProductId"",
		                    PSD.""PharmacyRetailStockId"",PSD.""Quantity"",
                            PSD.""Total"",PSD.""Discount"",PSD.""NetAmount"",
                                PRS.""BatchNumber"",PRS.""ExpiryDate""
                        from  ""PharmacyProduct"" PP
                        join ""PharmacySaleDetail"" PSD on PSD.""PharmacyProductId"" = PP.""PharmacyProductId""
                         join ""PharmacySaleHeader"" PSH on PSH.""PharmacySaleHeaderId"" = PSD.""PharmacySaleHeaderId""
                        join ""PharmacyRetailStock"" PRS on PRS.""PharmacyRetailStockId"" = PSD.""PharmacyRetailStockId""
                        join ""RetailWareHouseLink"" RWL on RWL.""RetailWareHouseLinkId"" = PRS.""RetailWareHouseLinkId""
                        join ""RetailPharmacy"" RP on RP.""RetailPharmacyId"" = RWL.""RetailPharmacyId""
                            -- where PP.""PharmacyProductId"" = {model.PharmacyProductId}
                                  {where}  ";

            return await this.unitOfWork.Current.QueryAsync<PharmacySaleBill>(query);

        }

        public async Task<IEnumerable<PharmacyRetailDetailModel>> FetchRetailStoreIssuedSaleAsync(PharmacyPurchaseReportBill model)
        {
            var where = $@"WHERE 1=1 ";
            if (model.PharmacyProductId != null)
            {
                where += $@" AND  PRS.""PharmacyProductId"" = {model.PharmacyProductId}";
            }
            if (!String.IsNullOrEmpty(model.BatchNumber))
            {
                where += $@" AND PRS.""BatchNumber"" ilike '%{model.BatchNumber}%'";
            }
            if (!string.IsNullOrEmpty(model.Barcode))
            {
                where += $@" and PRS.""Barcode"" = '{model.Barcode}' ";
            }
            var query = $@" SELECT 
                                 a.""AdmissionId"",  a.""AdmissionNo"", P.""FullName"" AS ""PatientName"",
	                            PP.""ProductName"",PRS.""BatchNumber"",
	                            PIND.""Quantity"" AS ""IndentQty"",PISD.""Quantity"" AS ""IssueQty"",	 
	                            PIH.""CreatedDate"" AS ""IndentDate"", PIHA.""FullName"" AS ""IndentByName"", PIHR.""RoleName"" AS ""IndentByRole"",
	                            PISH.""CreatedDate"" AS ""IssueDate"", ISA.""FullName"" as ""IssueByName"",	  ISR.""RoleName"" as ""IssueByRoleName"",	                             
	                             R.""ReceiptId"",
	                             RP.""RetailName"",
                                 PISD.""Total"",PISD.""DiscountAmount"",PISD.""NetAmount""
                                FROM
                                ""PharmacyProduct"" PP
                        JOIN ""PharmacyIssueDetail"" PISD ON PISD.""PharmacyProductId"" = PP.""PharmacyProductId""
                       JOIN ""PharmacyIssueHeader"" PISH ON PISH.""PharmacyIssueHeaderId"" = PISD.""PharmacyIssueHeaderId""
                      JOIN ""PharmacyIndentHeader"" PIH ON PIH.""PharmacyIndentHeaderId"" = PISH.""PharmacyIndentHeaderId""  
                     JOIN ""PharmacyIndentDetail"" PIND ON(PIND.""PharmacyIndentHeaderId"" = PIH.""PharmacyIndentHeaderId"" AND PIND.""PharmacyProductId"" = PP.""PharmacyProductId"")	
	                JOIN ""PharmacyRetailStock"" PRS on PRS.""PharmacyRetailStockId"" = PISD.""RetailStockId""
                    join ""RetailWareHouseLink"" RWL on RWL.""RetailWareHouseLinkId"" = PRS.""RetailWareHouseLinkId""
                     join ""RetailPharmacy"" RP on RP.""RetailPharmacyId"" = RWL.""RetailPharmacyId""
                     JOIN ""Account"" PIHA on PIHA.""AccountId"" = PIH.""CreatedBy""
                    JOIN ""Role"" PIHR on PIHR.""RoleId"" = PIHA.""RoleId""
                    JOIN ""Account"" ISA on ISA.""AccountId"" = PISH.""CreatedBy""
                    JOIN ""Role"" ISR on ISR.""RoleId"" = ISA.""RoleId""
                     JOIN ""Admission"" A ON A.""AdmissionId"" = PIH.""AdmissionId""    
                    JOIN ""Patient"" P ON P.""PatientId"" = A.""PatientId""
                     LEFT JOIN ""Receipt"" R on A.""AdmissionId"" = R.""AdmissionId""
                           {where} ";

            return await this.unitOfWork.Current.QueryAsync<PharmacyRetailDetailModel>(query);

        }

        public async Task<IEnumerable<PharmacyPurchaseReturnBillModel>> FetchPurchasedReturnAsync(PharmacyPurchaseReportBill model)
        {
            var where = $@"WHERE 1=1 ";
            //if (batchNumber != "null")
            //{
            //    where += $@" AND PS.""BatchNumber"" ='{batchNumber}'";
            //}
            if (model.PharmacyProductId != null)
            {
                where += $@" AND   PP.""PharmacyProductId"" = {model.PharmacyProductId} ";
            }
            if (!string.IsNullOrEmpty(model.BatchNumber))
            {
                where += $@" and PS.""BatchNumber"" ilike '%{model.BatchNumber}%' ";
            }
            if (!string.IsNullOrEmpty(model.Barcode))
            {
                where += $@" and PS.""Barcode"" = '{model.Barcode}' ";
            }
            var query = $@" SELECT  
		                         --   PPRH.""PharmacyPurchaseReturnHeaderId"",

                                        PPRH.""PharmacyPurchaseHeaderId"",
			                            PPRH.""BillNumber"",
			                            PPRH.""ReturnDate"",
			                            PPRH.""CreatedDate"",
                                            CA.""FullName"" as ""CreatedByName"",	 
				                            CR.""RoleName"" ,
		                        --    PPRD.""PharmacyPurchaseReturnDetailId"",
			                            PPRD.""PharmacyPurchaseDetailId"",
			                            PPRD.""PharmacyProductId"",
			                            PPRD.""ReturnQuantity"",
			                            PPRD.""Amount"", PPRD.""TaxAmount"",PPRD.""DiscountAmount"",
			                            PPRD.""TaxPercentage"",PPRD.""DiscountPercentage"",
			                            PPRD.""NetAmount"",
			                            PPRD.""PharmacyStockId"",
                                       PS.""BatchNumber"" ,
                                    PPH.""SupplierId"",
                                     S.""Name"" as ""SupplierName"",  W.""WareHouseName""
                                      from ""PharmacyProduct"" PP
                                    join""PharmacyPurchaseReturnDetail"" PPRD on PPRD.""PharmacyProductId"" = PP.""PharmacyProductId""

                                    join ""PharmacyPurchaseReturnHeader"" PPRH on PPRH.""PharmacyPurchaseReturnHeaderId"" = PPRD.""PharmacyPurchaseReturnHeaderId""
                                    join ""PharmacyPurchaseHeader""PH on PPRH.""PharmacyPurchaseHeaderId""=PH.""PharmacyPurchaseHeaderId""
                                   join ""PharmacyWareHouse"" W on W.""PharmacyWareHouseId"" = PH.""PharmacyWareHouseId"" 
                                    join ""PharmacyStock"" PS on PS.""PharmacyStockId""=PPRD.""PharmacyStockId""
                                    left join ""Account"" CA on CA.""AccountId"" = PPRH.""CreatedBy""
                                     left join ""Role"" CR on CA.""RoleId"" = CR.""RoleId""
                                    join ""PharmacyPurchaseDetail"" PPD on PPD.""PharmacyPurchaseDetailId""=PPRD.""PharmacyPurchaseDetailId""
                                    join ""PharmacyPurchaseHeader"" PPH on PPH.""PharmacyPurchaseHeaderId"" = PPD.""PharmacyPurchaseHeaderId""
                                    left join ""Supplier"" S on S.""SupplierId"" = PPH.""SupplierId""

                                      --where PP.""PharmacyProductId"" = {model.PharmacyProductId} 
                                     {where}   ";

            return await this.unitOfWork.Current.QueryAsync<PharmacyPurchaseReturnBillModel>(query);

        }

        public async Task<IEnumerable<PharmacySaleReturnBillDetailsModel>> FetchSoldReturnAsync(PharmacyPurchaseReportBill model)
        {
            var where = $@"WHERE 1=1";
            if (model.PharmacyProductId != null)
            {
                where += $@" AND   PP.""PharmacyProductId"" = {model.PharmacyProductId} ";
            }
            if (!String.IsNullOrEmpty(model.BatchNumber))
            {
                where += $@" AND PRS.""BatchNumber"" ilike '%{model.BatchNumber}%' ";
            }
            if (!string.IsNullOrEmpty(model.Barcode))
            {
                where += $@" and PRS.""Barcode"" = '{model.Barcode}' ";
            }
            var query = $@" select 
		                        SRH.""SaleReturnHeaderId"",

                                SRH.""ReturnDate"",
		                        SRH.""PatientName"",SRH.""PatientId"",
		                        SRH.""PharmacySaleHeaderId"",
		                        SRH.""CreatedDate"",
                                        CA.""FullName"" as ""CreatedByName"",	 
				                        CR.""RoleName"" ,
		                        SRD.""SaleReturnDetailId"",
		                        SRD.""Quantity"",
		                        SRD.""Total"",
		                        SRD.""TaxPercentage"", SRD.""TaxAmount"",SRD.""DiscountPercentage"",SRD.""DiscountAmount"",
		                        SRD.""NetAmount"",
		                        SRD.""PharmacyRetailStockId"",
		                        PRS.""BatchNumber"",
                                PSH.""BillNumber"",
                                RP.""RetailName""
                            from ""PharmacyProduct"" PP
                        join ""SaleReturnDetail"" SRD on SRD.""PharmacyProductId"" = PP.""PharmacyProductId""
                        join ""SaleReturnHeader"" SRH on SRD.""SaleReturnHeaderId"" = SRH.""SaleReturnHeaderId""
                        join ""PharmacyRetailStock"" PRS on SRD.""PharmacyRetailStockId"" = PRS.""PharmacyRetailStockId""                     
                    join ""RetailWareHouseLink"" RWL on RWL.""RetailWareHouseLinkId"" = PRS.""RetailWareHouseLinkId""
                     join ""RetailPharmacy"" RP on RP.""RetailPharmacyId"" = RWL.""RetailPharmacyId""
                     join ""PharmacySaleHeader"" PSH on PSH.""PharmacySaleHeaderId"" = SRH.""PharmacySaleHeaderId""
                        left join ""Account"" CA on CA.""AccountId"" = SRH.""CreatedBy""
                         left join ""Role"" CR on CA.""RoleId"" = CR.""RoleId""

                    -- where PP.""PharmacyProductId"" = {model.PharmacyProductId}
                      {where} ";

            return await this.unitOfWork.Current.QueryAsync<PharmacySaleReturnBillDetailsModel>(query);

        }

        public async Task<IEnumerable<PharmacySaleReturnBillDetailsModel>> FetchRetailToMainMovedAsync(PharmacyPurchaseReportBill model)
        {
            var where = $@"WHERE 1=1 ";
            if (model.PharmacyProductId != null)
            {
                where += $@" AND   PP.""PharmacyProductId"" = {model.PharmacyProductId} ";
            }
            if (!string.IsNullOrEmpty(model.BatchNumber))
            {
                where += $@" and PRS.""BatchNumber"" ilike '%{model.BatchNumber}%' ";
            }
            if (!string.IsNullOrEmpty(model.Barcode))
            {
                where += $@" and PRS.""Barcode"" = '{model.Barcode}' ";
            }
            var query = $@" select 
		                        PRTM.""PharmacyRetailToMainId"",

                               -- PRTM.""IssueDetailId"", 
			                        PRTM.""Quantity"",
		                        PRTM.""PharmacyProductId"",
		                        PRTM.""PharmacyRetailStockId"",
		                        PRTM.""PharmacyStockId"",
                                PRTM.""CreatedDate"",
                                    CA.""FullName"" as ""CreatedByName"",	 
			                        CR.""RoleName"" ,
		                        RP.""RetailName"",
		                        PRS.""BatchNumber""
                            from  ""PharmacyProduct"" PP
                            join ""PharmacyRetailToMain"" PRTM on PRTM.""PharmacyProductId"" = PP.""PharmacyProductId""
                             left join ""Account"" CA on CA.""AccountId"" = PRTM.""CreatedBy""
                             left join ""Role"" CR on CA.""RoleId"" = CR.""RoleId""    

                            left join ""PharmacyRetailStock"" PRS on PRS.""PharmacyRetailStockId"" = PRTM.""PharmacyRetailStockId""
                             join ""RetailWareHouseLink"" RWL on RWL.""RetailWareHouseLinkId""= PRS.""RetailWareHouseLinkId"" 
                              join ""RetailPharmacy"" RP on RP.""RetailPharmacyId"" = RWL.""RetailPharmacyId""
                           
                      {where} ";

            return await this.unitOfWork.Current.QueryAsync<PharmacySaleReturnBillDetailsModel>(query);

        }

        public async Task<IEnumerable<PharmacyStockDetailModel>> FetchRetailRecordAsync(PharmacyPurchaseReportBill model)
        {
            var where = $@"WHERE 1=1 ";
            if (model.PharmacyProductId != null)
            {
                where += $@" AND   PP.""PharmacyProductId"" = {model.PharmacyProductId} ";
            }
            if (!string.IsNullOrEmpty(model.BatchNumber))
            {
                where += $@" and PS.""BatchNumber"" ilike '%{model.BatchNumber}%' ";
            }
            if (!string.IsNullOrEmpty(model.Barcode))
            {
                where += $@" and PS.""Barcode"" = '{model.Barcode}' ";
            }
            var query=$@"select RS.""QuantityIn"",RS.""QuantityOut"",RS.""BatchNumber"",RS.""ExpiryDate"",RS.""Barcode"",
                        W.""WareHouseName"",R.""RetailName"", PR.""Quantity"" as ""MovedQuantity""
                        from ""PharmacyProduct"" PP
                        join ""PharmacyRetailStock"" RS on RS.""PharmacyProductId"" = PP.""PharmacyProductId""
                        join ""PharmacyStock"" PS on PS.""PharmacyStockId"" = RS.""PharmacyStockId""
                        
                        join ""RetailWareHouseLink"" RWL on RWL.""RetailWareHouseLinkId"" = RS.""RetailWareHouseLinkId""
                        join ""PharmacyWareHouse"" W on W.""PharmacyWareHouseId"" = RWL.""PharmacyWareHouseId""
                        Join ""RetailPharmacy"" R on R.""RetailPharmacyId"" = RWL.""RetailPharmacyId""
                        left join ""PharmacyRetailToMain"" PR on PR.""PharmacyRetailStockId""=RS.""PharmacyRetailStockId""
                        { where}";
                return await this.unitOfWork.Current.QueryAsync<PharmacyStockDetailModel>(query);
        }

        public async Task<IEnumerable<PharmacyPurchaseReportBill>> FetchWareHouseRecordAsync(PharmacyPurchaseReportBill model)
        {
            var where = $@"WHERE 1=1 ";
            if (model.PharmacyProductId != null)
            {
                where += $@" AND   PP.""PharmacyProductId"" = {model.PharmacyProductId} ";
            }
            if (!string.IsNullOrEmpty(model.BatchNumber))
            {
                where += $@" and PS.""BatchNumber"" ilike '%{model.BatchNumber}%' ";
            }
            if (!string.IsNullOrEmpty(model.Barcode))
            {
                where += $@" and PS.""Barcode"" = '{model.Barcode}' ";
            }
            var query = $@"select PH.""BillNumber"",PH.""BillDate"", PD.""Quantity"",PD.""Free"",
                        PS.""QuantityIn"",PS.""QuantityOut"", PS.""PurchaseRate"",PS.""Mrp"",PS.""BatchNumber"",PS.""ExpiryDate"",
                        W.""WareHouseName"",PRD.""ReturnQuantity""
                        from ""PharmacyProduct"" PP
                        join ""PharmacyPurchaseDetail"" PD on PD.""PharmacyProductId"" = PP.""PharmacyProductId""
                        join ""PharmacyPurchaseReturnDetail"" PRD on PRD.""PharmacyPurchaseDetailId""=PD.""PharmacyPurchaseDetailId""
                        join ""PharmacyPurchaseHeader"" PH on PH.""PharmacyPurchaseHeaderId"" = PD.""PharmacyPurchaseHeaderId""
                        join ""PharmacyStock"" PS on PS.""PharmacyStockId"" = PD.""PharmacyStockId""

                        join ""PharmacyWareHouse"" W on W.""PharmacyWareHouseId"" = PH.""PharmacyWareHouseId""
                        {where} ";
            return await this.unitOfWork.Current.QueryAsync<PharmacyPurchaseReportBill>(query);
        }
    }
}