﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The pharmacy sale return bill details model.
    /// </summary>
    public class PharmacySaleReturnBillDetailsModel
    {
        /// <summary>
        /// Gets or sets the return date.
        /// </summary>
        public DateTime ReturnDate { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the sale return details id.
        /// </summary>
        public int? SaleReturnDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the sale return header id.
        /// </summary>
        public int? SaleReturnHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy sale detail id.
        /// </summary>
        public int PharmacySaleDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy sale header id.
        /// </summary>
        public int PharmacySaleHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }


        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }


        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double? Mrp { get; set; }

        /// <summary>
        /// Gets or sets the overall total.
        /// </summary>
        public double? OverallTotal { get; set; }

        /// <summary>
        /// Gets or sets the overall taxes.
        /// </summary>
        public double? OverallTaxes { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        public double? OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the BatchNumber
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by  person's -Role .
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the retailName.
        /// </summary>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the patient first name.
        /// </summary>
        public string FirstName { get; set; }
        /// <summary>
        /// Gets or sets the patient middle name.
        /// </summary>
        public string LastName { get; set; }
        /// <summary>
        /// Gets or sets the patient last name.
        /// </summary>
        public string MiddleName { get; set; }
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient dob.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }
    }
}
