﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The Menu Access.
    /// </summary>
    public class MenuButtonRelationship
    {
        /// <summary>
        /// Gets or sets the menu relationship identifier.
        /// </summary>
        /// <value>
        /// The menu relationship identifier.
        /// </value>
        [Key, Identity]
        public int MenuButtonRelationshipId { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the menu identifier.
        /// </summary>
        /// <value>
        /// The menu identifier.
        /// </value>
        public int MenuButtonId { get; set; }   
       
    }
}
