﻿using System;

namespace Hims.Domain.Services
{
    using System.ComponentModel.Design;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.Common;
    using Shared.UserModels.FinalBill;

    /// <summary> The ChatService interface.</summary>
    public interface IFinalBillService
    {
        Task<int> UpdatePackageCompleteness(int id, bool isAdmission, bool active);
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        Task<int> GetDefaultChargeId();

        /// <summary>
        /// Determines whether [is discharged asynchronous] [the specified model].
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<DateTime?> IsDischargedAsync(FilterModel model);

        /// <summary>
        /// Gets the basic asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<BasicViewModel> GetBasicAsync(FilterModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<ViewModel> FetchAsync(FilterModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Cancels the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> CancelAsync(FilterModel model);
        /// <summary>
        /// FetchFinalBillDetails Async
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<BasicModel> FetchFinalBillDetailsAsync(IdModel model);

        Task<int> UpdatePackageActivity(int id,bool isAdmission,bool active);
    }
}
