﻿namespace Hims.Domain.Services
{
    using Domain.Entities;

    using System.Collections.Generic;
    using System.Threading.Tasks;

    using Shared.UserModels.Insurance;

    /// <summary>
    /// The Insurance admission Service interface.
    /// </summary>
    public interface IInsuranceAdmissionService
    {
        /// <summary>
        /// The add insurance for admission.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> AddInsuranceForAdmission(AdmissionInsuranceModel model);

        /// <summary>
        /// The update insurance for admission.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> UpdateInsuranceForAdmission(AdmissionInsuranceModel model);


        /// <summary>
        /// The update insurance for admission.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> UpdateInsuranceApproval(AdmissionInsuranceModel model);
        

        /// <summary>
        /// The get insurance for admission.
        /// </summary>
        /// <param name="admissionId">
        /// The admission id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<InsuranceForAdmission> GetInsuranceForAdmission(int admissionId);

        /// <summary>
        /// The fetch all.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<AdmissionInsuranceModel>> FetchAll(AdmissionInsuranceModel model);

        /// <summary>
        /// The fetch all.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<AdmissionInsuranceModel>> FetchAdmissionInsuranceApprovals(AdmissionInsuranceModel model);

        /// <summary>
        /// The fetch all.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<AdmissionInsuranceModel>> FetchAppointmentInsuranceApprovals(AdmissionInsuranceModel model);

        /// <summary>
        /// The insert insurance timeline.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> InsertInsuranceTimeline(AdmissionInsuranceModel model);

        /// <summary>
        /// The fetch all insurance timeline async.
        /// </summary>
        /// <param name="insuranceForAdmissionId">
        /// The insurance for admission id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<AdmissionInsuranceModel>> FetchAllInsuranceTimelineAsync(int insuranceForAdmissionId);

        /// <summary>
        /// The add insurance for approvals.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<int> AddInsuranceApproval(AdmissionInsuranceModel model);

        /// <summary>
        /// The check insurance for approvals.
        /// </summary>
        /// <param name="admissionId"></param>
        /// <param name="patientInsuranceId"></param>
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<InsuranceApproval> GetInsuranceAdmissionApproval(int admissionId,int patientInsuranceId);

        /// <summary>
        /// The check insurance for approvals.
        /// </summary>
        /// <param name="appointmentId"></param>
        /// <param name="patientInsuranceId"></param>
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<InsuranceApproval> GetInsuranceAppointmentApproval(int appointmentId, int patientInsuranceId);


        /// <summary>
        /// The check insurance for approvals.
        /// </summary>
        /// <param name="admissionId"></param>
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<AdmissionInsuranceModel>> FetchInsuranceApprovalsByAdmissionIdAysnc(int admissionId);

        /// <summary>
        /// The check insurance for approvals.
        /// </summary>
        /// <param name="appointmentId"></param>
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<IEnumerable<AdmissionInsuranceModel>> FetchInsuranceApprovalsByAppointmentIdAysnc(int appointmentId);
    }
}
